<?php

namespace backend\modules\moduleRepository\controllers;

use Yii;
use backend\modules\moduleRepository\models\ModuleList;
use backend\modules\moduleRepository\models\ModuleVersion;
use backend\modules\moduleRepository\models\ModuleListSearch;
use backend\modules\moduleRepository\models\ModuleDownload;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\web\UploadedFile;
use yii\helpers\ArrayHelper;
use yii\helpers\Html;

/**
 * ModuleListController implements the CRUD actions for ModuleList model.
 */
class ModuleListController extends Controller {

    /**
     * {@inheritdoc}
     */
    public function behaviors() {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }
    
    public function actionAdddownload($id) {
        $model = new ModuleDownload();
        $model->version_id = $id;
        $model->download_at = date("Y-m-d H:i:s");
        $model->save();
    }

    /**
     * Lists all ModuleList models.
     * @return mixed
     */
    public function actionIndex() {
        $searchModel = new ModuleListSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
                    'searchModel' => $searchModel,
                    'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single ModuleList model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id) {
        return $this->render('view', [
                    'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new ModuleList model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate() {
        $model = new ModuleList();
        $model->created_at = date("Y-m-d H:i:s");
        $model->created_by = Yii::$app->user->identity->id;
        $model->updated_at = date("Y-m-d H:i:s");
        $model->updated_by = Yii::$app->user->identity->id;
        if ($model->load(Yii::$app->request->post())) {
            $model->module_image = UploadedFile::getInstance($model, 'module_image');
            if (!empty($model->module_image)) {
                $module_image = 'images/modules/moduleRepository_' . date("YmdHis") . '.' . $model->module_image->extension;
                if ($model->module_image->saveAs($module_image))
                    $model->module_image = $module_image;
            }
            if ($model->save()) {

                //insert new version
                if (isset($_POST['newversion']) && !empty($_POST['newversion'])) {
                    foreach ($_POST['newversion'] as $newno) {
                        $modelnew = new ModuleVersion();
                        $modelnew->module_id = $model->module_id;
                        $modelnew->module_version = $_POST['new_version_' . $newno];
                        $modelnew->module_remarks = $_POST['new_remarks_' . $newno];
                        $modelnew->created_at = date("Y-m-d H:i:s");
                        $modelnew->created_by = Yii::$app->user->identity->id;
                        $modelnew->updated_at = date("Y-m-d H:i:s");
                        $modelnew->updated_by = Yii::$app->user->identity->id;
                        $modelnew->module_url = UploadedFile::getInstanceByName('new_upload_' . $newno);
                        if (!empty($modelnew->module_url)) {
                            $module_zip = 'zip_file/modules_' . $modelnew->module_url->basename .'_'. date("YmdHis") . '.' . $modelnew->module_url->extension;
                            if ($modelnew->module_url->saveAs($module_zip))
                                $modelnew->module_url = $module_zip;
                        }
                        $modelnew->save();
                    }
                }
                return $this->redirect(['index']);
            }
        }
        return $this->render('create', ['model' => $model,]);
    }

    /**
     * Updates an existing ModuleList model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id) {
        $model = $this->findModel($id);
        $model->updated_at = date("Y-m-d H:i:s");
        $model->updated_by = Yii::$app->user->identity->id;
        $original_module_image = $model->module_image;
        if ($model->load(Yii::$app->request->post())) {
            $model->module_image = UploadedFile::getInstance($model, 'module_image');
            if (!empty($model->module_image)) {
                $module_image = 'images/modules/moduleRepository_' . date("YmdHis") . '.' . $model->module_image->extension;
                if ($model->module_image->saveAs($module_image))
                    $model->module_image = $module_image;
            } else
                $model->module_image = $original_module_image;
            if ($model->save()) {

                //insert new version
                if (isset($_POST['newversion']) && !empty($_POST['newversion'])) {
                    foreach ($_POST['newversion'] as $newno) {
                        $modelnew = new ModuleVersion();
                        $modelnew->module_id = $model->module_id;
                        $modelnew->module_version = $_POST['new_version_' . $newno];
                        $modelnew->module_remarks = $_POST['new_remarks_' . $newno];
                        $modelnew->created_at = date("Y-m-d H:i:s");
                        $modelnew->created_by = Yii::$app->user->identity->id;
                        $modelnew->updated_at = date("Y-m-d H:i:s");
                        $modelnew->updated_by = Yii::$app->user->identity->id;
                        $modelnew->module_url = UploadedFile::getInstanceByName('new_upload_' . $newno);
                        if (!empty($modelnew->module_url)) {
                            $module_zip = 'zip_file/modules_' . $modelnew->module_url->basename .'_'. date("YmdHis") . '.' . $modelnew->module_url->extension;
                            if ($modelnew->module_url->saveAs($module_zip))
                                $modelnew->module_url = $module_zip;
                        }
                        $modelnew->save();
                    }
                }
                return $this->redirect(['index']);
            }
        }
        return $this->render('update', ['model' => $model,]);
    }

    /**
     * Deletes an existing ModuleList model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id) {
        ModuleVersion::deleteAll(['module_id' => $id]);
        $this->findModel($id)->delete();
        return $this->redirect(['index']);
    }

    /**
     * Finds the ModuleList model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return ModuleList the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id) {
        if (($model = ModuleList::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
    }

    public function actionAddnewversion($no = '', $controller_name = '') {

        $version_label = '';
        $remarks_label = '';
        if ($no == '1' && $controller_name == 'create') {
            $version_label = '1.0';
            $remarks_label = 'First version of modules';
        }

        $output = '<tr><input type="hidden" name="newversion[]" value="' . $no . '">
            <td><input type="text" class="form-control" name="new_version_' . $no . '" id="new_version_' . $no . '" value="' . $version_label . '"></td>
            <td><input type="text" class="form-control" name="new_remarks_' . $no . '" id="new_remarks_' . $no . '" value="' . $remarks_label . '"></td>
            <td><input type="file" class="form-control" name="new_upload_' . $no . '"></td>
        </tr>';
        return $output;
    }

}
