<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model backend\models\frontenduser\FrontendUser */

$this->title = $model->id;
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Frontend Users'), 'url' => ['index']];
$this->params['breadcrumbs'][] = 'View Frontend User';
$this->registerCss('.detail-view th{width:1%;text-align:right;white-space: nowrap;}')
?>
<div class="frontend-user-view">
    <div class="wrapper wrapper-content animated fadeInRight">
        <?= Html::a(Yii::t('app', 'Back to list'), ['index'], ['class' => 'btn btn-primary']) ?><br><br>
        <div class="ibox float-e-margins">
            <div class="ibox-content">
                <?php
                if (!empty($model->img_url))
                    echo '<center><img src="../../' . $model->img_url . '" style="height:150px;margin-bottom : 1em;"></center>';
                ?>
                <?=
                DetailView::widget([
                    'model' => $model,
                    'attributes' => [
                        [
                            'attribute' => 'role',
                            'value' => \backend\modules\refdynawebv2\models\Ref::getDesc('FRONTUSER_ROLE', $model->role, 'descr_en'),
                        ],
                        'fullname',
                        'username',
                        [
                            'attribute' => 'gender',
                            'value' => \backend\modules\refdynawebv2\models\Ref::getDesc('GENDER', $model->gender, 'descr_en'),
                        ],
                        'mobile_no',
                        'office_no',
                        'email',
                        [
                            'attribute' => 'state',
                            'value' => \backend\modules\refdynawebv2\models\Ref::getDesc('STATE', $model->state, 'descr_en'),
                        ],
                        [
                            'attribute' => 'branch',
                            'value' => \backend\modules\refdynawebv2\models\Ref::getDesc('BRANCH', $model->branch, 'descr_en'),
                        ],
                        [
                            'attribute' => 'department',
                            'value' => \backend\modules\refdynawebv2\models\Ref::getDesc('DEPARTMENT', $model->department, 'descr_en'),
                        ],
                        [
                            'attribute' => 'unit',
                            'value' => \backend\modules\refdynawebv2\models\Ref::getDesc('UNIT', $model->unit, 'descr_en'),
                        ],
                        [
                            'attribute' => 'service_group',
                            'value' => \backend\modules\refdynawebv2\models\Ref::getDesc('SERVICE_GROUP', $model->service_group, 'descr_en'),
                        ],
                        [
                            'attribute' => 'service_classification',
                            'value' => \backend\modules\refdynawebv2\models\Ref::getDesc('SERVICE_CLASSIFICATION', $model->service_classification, 'descr_en'),
                        ],
                        [
                            'attribute' => 'gred',
                            'value' => \backend\modules\refdynawebv2\models\Ref::getDesc('GRADE', $model->gred, 'descr_en'),
                        ],
                        [
                            'attribute' => 'gred_post',
                            'value' => \backend\modules\refdynawebv2\models\Ref::getDesc('GRADE_POST', $model->gred_post, 'descr_en'),
                        ],
                        'designation',
                        [
                            'attribute' => 'service_status',
                            'value' => \backend\modules\refdynawebv2\models\Ref::getDesc('SERVICE_STATUS', $model->service_status, 'descr_en'),
                        ],
                        [
                            'attribute' => 'service_status_latest',
                            'value' => \backend\modules\refdynawebv2\models\Ref::getDesc('USER_STATUS', $model->service_status_latest, 'descr_en'),
                        ],
                        [
                            'attribute' => 'status',
                            'value' => \backend\modules\refdynawebv2\models\Ref::getDesc('ACTIVE_STATUS', $model->status, 'descr_en'),
                        ],
                        'remarks'
                    ],
                ])
                ?>
            </div>
        </div>
    </div>
</div>