<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\Pjax;
use yii\helpers\Url;
use backend\models\frontenduser\FrontendUser;
use yii\helpers\ArrayHelper;

/* @var $this yii\web\View */
/* @var $searchModel backend\models\frontenduser\FrontendUserSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = Yii::t('app', 'Frontend Users');
$this->params['breadcrumbs'][] = $this->title;

if (Yii::$app->getRequest()->getQueryParam('resetpwd') == 'success') {
    $this->registerJs("alert('User password has been reset to 123456');window.location.href = '../../fruserdynav2/frontend-user/index';");
}
if (Yii::$app->getRequest()->getQueryParam('resetpwd') == 'failed') {
    $this->registerJs("alert('User password failed to reset. Please try again');window.location.href = '../../fruserdynav2/frontend-user/index';");
}
?>
<div class="wrapper wrapper-content animated fadeInRight">
    <p>
        <?= Html::a(yii::t('app', 'Add User'), Url::to(['create']), ['class' => 'btn btn-success ']) ?>
    </p>
    <div class="ibox">
        <div class="mail-box b-r-md">
            <?php Pjax::begin(); ?>
            <?=
            GridView::widget([
                'dataProvider' => $dataProvider,
                'filterModel' => $searchModel,
                'tableOptions' => ['class' => 'table'],
                'summary' => '',
                'columns' => [
                    [
                        'class' => 'yii\grid\SerialColumn',
                        'headerOptions' => ['class' => 'text-center'],
                        'contentOptions' => ['class' => 'text-center text-nowrap', 'width' => '3%'],
                    ],
                    [
                        'attribute' => 'username',
                    ],
                    'fullname',
                    [
                        'attribute' => 'role',
                        'filter' => ArrayHelper::map(\backend\modules\refdynawebv2\models\Ref::find()->where(['cat' => 'FRONTUSER_ROLE'])->orderBy(['descr_en' => SORT_ASC])->all(), 'code', 'descr_en'),
                        //'contentOptions' => ['class' => 'text-nowrap', 'width' => '3%'],
                        'format' => 'raw',
                        'value' => function($model) {
                            return \backend\modules\refdynawebv2\models\Ref::getDesc('FRONTUSER_ROLE', $model->role, 'descr_en');
                        }
                    ],
                    [
                        'attribute' => 'branch',
                        'filter' => ArrayHelper::map(\backend\modules\refdynawebv2\models\Ref::find()->where(['cat' => 'BRANCH'])->orderBy(['descr_en' => SORT_ASC])->all(), 'code', 'descr_en'),
                        'format' => 'raw',
                        'value' => function($model) {
                            return \backend\modules\refdynawebv2\models\Ref::getDesc('BRANCH', $model->branch, 'descr_en');
                        }
                    ],
                    [
                        'header' => 'Action',
                        'class' => 'yii\grid\ActionColumn',
                        'contentOptions' => ['class' => 'text-center text-nowrap', 'width' => '1%'],
                        'template' => '&nbsp;&nbsp;{view}&nbsp;&nbsp;{update}&nbsp;&nbsp;{delete}&nbsp;&nbsp;{resetpwd}&nbsp;&nbsp;',
                        'buttons' => [
                            'resetpwd' => function ($url, $model) {
                                return Html::a('<i class="fa fa-key"></i>', ['resetpwd', 'id' => $model->id], ['title' => 'Reset Password', 'data-confirm' => 'Are you sure you want to reset password this user?']);
                            },
                        ]
                    ],
                ],
            ]);
            ?>
            <?php Pjax::end(); ?>
        </div>
    </div>
</div>