<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use backend\modules\refdynawebv2\models\Ref;
use backend\modules\fruserdynav2\models\FrontendUser;
use backend\modules\mimin\models\UserSearch;
use yii\helpers\ArrayHelper;
use kartik\file\FileInput;

$this->params['extra-asset']['CSS'][] = 'plugins/select2/select2.min.css';
$this->params['extra-asset']['JS'][] = 'plugins/select2/select2.full.min.js';

$this->registerJS(<<<JS
    $('.select2').select2({width:'100%'});
JS
);

$this->registerCss('.select2-container--default .select2-selection--single{border-radius: 1px;}
    .select2-container .select2-selection--single{height: 34px;}
    .select2-container--default .select2-selection--single .select2-selection__rendered {line-height: 34px;}
');

/* @var $this yii\web\View */
/* @var $model backend\models\frontenduser\FrontendUser */
/* @var $form yii\widgets\ActiveForm */
?>
<div class="wrapper wrapper-content animated fadeInRight">
    <div class="ibox float-e-margins">
        <div class="ibox-content">
            <?php $form = ActiveForm::begin(); ?>
            <?php //= $form->errorSummary($model) ?>
            
            <div class="row">
                <div class="col-sm-4">
                    <?php
                    if ($model->isNewRecord)
                        echo $form->field($model, 'username')->textInput(['maxlength' => true]);
                    else
                        echo $form->field($model, 'username')->textInput(['maxlength' => true, 'readonly' => true]);
                    ?>
                </div>
                <div class="col-sm-4"><?= $form->field($model, 'password')->passwordInput(['autocomplete' => 'new-password']); ?></div>
                <div class="col-sm-4"><?= $form->field($model, 'role')->dropdownList(ArrayHelper::map(\backend\modules\refdynawebv2\models\Ref::find()->where(['cat' => 'FRONTUSER_ROLE'])->orderBy(['descr_en' => SORT_ASC])->all(), 'code', 'descr_en'), ['maxlength' => true, 'prompt' => '- Please choose - ', 'class' => 'select2']) ?></div>
            </div>
            <div class="row">
                <div class="col-sm-8"><?= $form->field($model, 'fullname')->textInput(['maxlength' => true]) ?></div>
                <div class="col-sm-4"><?= $form->field($model, 'gender')->dropdownList(ArrayHelper::map(\backend\modules\refdynawebv2\models\Ref::find()->where(['cat' => 'GENDER'])->orderBy(['descr_en' => SORT_ASC])->all(), 'code', 'descr_en'), ['maxlength' => true, 'prompt' => '- Please choose - ', 'class' => 'select2']) ?></div>
            </div>
            <div class="row">
                <div class="col-sm-4"><?= $form->field($model, 'mobile_no')->textInput(['maxlength' => true]) ?></div>
                <div class="col-sm-4"><?= $form->field($model, 'office_no')->textInput(['maxlength' => true]) ?></div>
                <div class="col-sm-4"><?= $form->field($model, 'email')->textInput(['maxlength' => true]) ?></div>
            </div>
            <div class="row">
                <div class="col-sm-4"><?= $form->field($model, 'state')->dropdownList(ArrayHelper::map(\backend\modules\refdynawebv2\models\Ref::find()->where(['cat' => 'STATE'])->orderBy(['descr_en' => SORT_ASC])->all(), 'code', 'descr_en'), ['maxlength' => true, 'prompt' => '- Please choose - ', 'onchange' => "getreflist(this.value,'STATE')", 'class' => 'select2']) ?></div>
                <div class="col-sm-4"><?= $form->field($model, 'branch')->dropdownList(ArrayHelper::map(\backend\modules\refdynawebv2\models\Ref::find()->where(['cat' => 'BRANCH', 'param1' => $model->getparentid($model->state, 'STATE')])->orderBy(['descr_en' => SORT_ASC])->all(), 'code', 'descr_en'), ['maxlength' => true, 'prompt' => '- Please choose - ', 'onchange' => "getreflist(this.value,'BRANCH')", 'class' => 'select2']) ?></div>
                <div class="col-sm-4"><?= $form->field($model, 'department')->dropdownList(ArrayHelper::map(\backend\modules\refdynawebv2\models\Ref::find()->where(['cat' => 'DEPARTMENT', 'param1' => $model->getparentid($model->branch, 'BRANCH')])->orderBy(['descr_en' => SORT_ASC])->all(), 'code', 'descr_en'), ['maxlength' => true, 'prompt' => '- Please choose - ', 'onchange' => "getreflist(this.value,'DEPARTMENT')", 'class' => 'select2']) ?></div>
            </div>
            <div class="row">
                <div class="col-sm-4"><?= $form->field($model, 'unit')->dropdownList(ArrayHelper::map(\backend\modules\refdynawebv2\models\Ref::find()->where(['cat' => 'UNIT', 'param1' => $model->getparentid($model->department, 'DEPARTMENT')])->orderBy(['descr_en' => SORT_ASC])->all(), 'code', 'descr_en'), ['maxlength' => true, 'prompt' => '- Please choose - ', 'class' => 'select2']) ?></div>
                <div class="col-sm-4"><?= $form->field($model, 'service_group')->dropdownList(ArrayHelper::map(\backend\modules\refdynawebv2\models\Ref::find()->where(['cat' => 'SERVICE_GROUP'])->orderBy(['descr_en' => SORT_ASC])->all(), 'code', 'descr_en'), ['maxlength' => true, 'prompt' => '- Please choose - ', 'class' => 'select2']) ?></div>
                <div class="col-sm-4"><?= $form->field($model, 'service_classification')->dropdownList(ArrayHelper::map(\backend\modules\refdynawebv2\models\Ref::find()->where(['cat' => 'SERVICE_CLASSIFICATION'])->orderBy(['descr_en' => SORT_ASC])->all(), 'code', 'descr_en'), ['maxlength' => true, 'prompt' => '- Please choose - ', 'class' => 'select2']) ?></div>
            </div>
            <div class="row">
                <div class="col-sm-4"><?= $form->field($model, 'gred')->dropdownList(ArrayHelper::map(\backend\modules\refdynawebv2\models\Ref::find()->where(['cat' => 'GRADE'])->orderBy(['descr_en' => SORT_ASC])->all(), 'code', 'descr_en'), ['maxlength' => true, 'prompt' => '- Please choose - ', 'class' => 'select2']) ?></div>
                <div class="col-sm-4"><?= $form->field($model, 'gred_post')->dropdownList(ArrayHelper::map(\backend\modules\refdynawebv2\models\Ref::find()->where(['cat' => 'GRADE_POST'])->orderBy(['descr_en' => SORT_ASC])->all(), 'code', 'descr_en'), ['maxlength' => true, 'prompt' => '- Please choose - ', 'class' => 'select2']) ?></div>
                <div class="col-sm-4"><?= $form->field($model, 'designation')->textInput(['maxlength' => true]) ?></div>
            </div>
            <div class="row">
                <div class="col-sm-4"><?= $form->field($model, 'service_status')->dropdownList(ArrayHelper::map(\backend\modules\refdynawebv2\models\Ref::find()->where(['cat' => 'SERVICE_STATUS'])->orderBy(['descr_en' => SORT_ASC])->all(), 'code', 'descr_en'), ['maxlength' => true, 'prompt' => '- Please choose - ', 'class' => 'select2']) ?></div>
                <div class="col-sm-4"><?= $form->field($model, 'service_status_latest')->dropdownList(ArrayHelper::map(\backend\modules\refdynawebv2\models\Ref::find()->where(['cat' => 'USER_STATUS'])->orderBy(['descr_en' => SORT_ASC])->all(), 'code', 'descr_en'), ['maxlength' => true, 'prompt' => '- Please choose - ', 'class' => 'select2']) ?></div>
                <div class="col-sm-4"><?= $form->field($model, 'status')->dropdownList(ArrayHelper::map(\backend\modules\refdynawebv2\models\Ref::find()->where(['cat' => 'ACTIVE_STATUS'])->orderBy(['descr_en' => SORT_ASC])->all(), 'code', 'descr_en'), ['maxlength' => true, 'prompt' => '- Please choose - ', 'class' => 'select2']) ?></div>
            </div>
            <?= $form->field($model, 'remarks')->textarea(['rows' => '6']) ?>
            <div class="row">
                <div class="col-sm-4">
                    <?php
                    if (!empty($model->img_url)) {
                        echo $form->field($model, 'img_url')->widget(FileInput::classname(), [
                            'options' => ['accept' => 'image/*'],
                            'pluginOptions' => [
                                'initialPreview' => ['../../' . $model->img_url],
                                'initialPreviewAsData' => true,
                            ]
                        ]);
                    } else {
                        echo $form->field($model, 'img_url')->widget(FileInput::classname(), [
                            'options' => ['accept' => 'image/*'],
                        ]);
                    }
                    ?>
                </div>
            </div>
            <div class="form-group">
                <?= Html::a(Yii::t('app', 'Back'), ['index'], ['class' => 'btn btn-primary']) ?>
                <?= Html::submitButton(Yii::t('app', 'Save'), ['class' => 'btn btn-success']) ?>
            </div>
            <?php ActiveForm::end(); ?>
        </div>
    </div>
</div>
<script>
    function getreflist(code, cat) {
        $.ajax({
            url: "getreflist?code=" + code + '&cat=' + cat,
            method: "GET",
            success: function (response) {
                //state
                if (cat === 'STATE') {
                    $('#frontenduser-branch').html(response);
                    $('#frontenduser-department').html('<option value="">- Please choose -</option>');
                    $('#frontenduser-unit').html('<option value="">- Please choose -</option>');
                    $('#frontenduser-branch').val('');
                    $('#frontenduser-department').val('');
                    $('#frontenduser-unit').val('');
                }
                //branch
                if (cat === 'BRANCH') {
                    $('#frontenduser-department').html(response);
                    $('#frontenduser-unit').html('<option value="">- Please choose -</option>');
                    $('#frontenduser-department').val('');
                    $('#frontenduser-unit').val('');
                }
                //department
                if (cat === 'DEPARTMENT') {
                    $('#frontenduser-unit').html(response);
                    $('#frontenduser-unit').val('');
                }
                $('.select2').select2({width: '100%'});
            }
        });
    }
</script>