<?php

namespace backend\modules\fruserdynav2\controllers;

use Yii;
use backend\modules\fruserdynav2\models\FrontendUser;
use backend\modules\fruserdynav2\models\FrontendUserSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use common\components\AccessRule;
use yii\web\UploadedFile;
use backend\modules\refdynawebv2\models\Ref;

/**
 * FrontendUserController implements the CRUD actions for FrontendUser model.
 */
class FrontendUserController extends Controller {

    /**
     * {@inheritdoc}
     */
    public function behaviors() {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'ruleConfig' => [
                    'class' => AccessRule::className(),
                ],
                'rules' => [
                    [
                        'actions' => ['index', 'create', 'update', 'view', 'delete', 'resetpwd'],
                        'allow' => true,
                        'roles' => ['@'],
                    ], [
                        'allow' => true,
                        'actions' => ['getreflist', 'getreflistmy'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all FrontendUser models.
     * @return mixed
     */
    public function actionIndex() {
        $searchModel = new FrontendUserSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
        return $this->render('index', ['searchModel' => $searchModel, 'dataProvider' => $dataProvider,]);
    }

    /**
     * Displays a single FrontendUser model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id) {
        return $this->render('view', ['model' => $this->findModel($id),]);
    }

    /**
     * Creates a new FrontendUser model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate() {
        $model = new FrontendUser();
        $model->scenario = "create";
        if ($model->load(Yii::$app->request->post())) {
            $model->created_at = date("Y-m-d H:i:s");
            $model->created_by = Yii::$app->user->identity->id;
            $model->created_user_type = 'backend_user';
            $model->updated_at = date("Y-m-d H:i:s");
            $model->updated_by = Yii::$app->user->identity->id;
            $model->updated_user_type = 'backend_user';
            $model->auth_key = Yii::$app->security->generateRandomString();
            $model->password_hash = Yii::$app->security->generatePasswordHash($model->password);
            $model->img_url = UploadedFile::getInstance($model, 'img_url');
            if (!empty($model->img_url)) {
                $img_url = 'uploads/frontend_user/user_' . date("YmdHis") . '.' . $model->img_url->extension;
                if ($model->img_url->saveAs($img_url))
                    $model->img_url = $img_url;
            }

            if ($model->save()) {
                return $this->redirect(['index']);
            }
        }
        return $this->render('create', ['model' => $model,]);
    }

    /**
     * Updates an existing FrontendUser model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id) {
        $model = $this->findModel($id);
        $original_img_url = $model->img_url;
        if ($model->load(Yii::$app->request->post())) {
            $model->updated_at = date("Y-m-d H:i:s");
            $model->updated_by = Yii::$app->user->identity->id;
            $model->updated_user_type = 'backend_user';
            $model->img_url = UploadedFile::getInstance($model, 'img_url');
            if (!empty($model->password))
                $model->password_hash = Yii::$app->security->generatePasswordHash($model->password);
            if (!empty($model->img_url)) {
                $img_url = 'uploads/frontend_user/user_' . date("YmdHis") . '.' . $model->img_url->extension;
                if ($model->img_url->saveAs($img_url))
                    $model->img_url = $img_url;
            } else {
                $model->img_url = $original_img_url;
            }

            if ($model->save()) {
                return $this->redirect(['index']);
            }
        }
        return $this->render('update', ['model' => $model,]);
    }

    /**
     * Deletes an existing FrontendUser model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id) {
        $this->findModel($id)->delete();
        return $this->redirect(['index']);
    }

    /**
     * Finds the FrontendUser model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return FrontendUser the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id) {
        if (($model = FrontendUser::findOne($id)) !== null) {
            return $model;
        }
        throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
    }

    public function actionResetpwd($id) {
        $model = $this->findModel($id);
        $model->updated_at = date("Y-m-d H:i:s");
        $model->updated_by = Yii::$app->user->identity->id;
        $model->password_hash = Yii::$app->security->generatePasswordHash('123456');
        if ($model->save(false)) {
            return $this->redirect(['index', 'resetpwd' => 'success']);
        } else {
            return $this->redirect(['index', 'resetpwd' => 'failed']);
        }
    }

    public function actionGetreflist($code, $cat) {
        $output = '<option value="">- Please choose -</option>';
        if (($model2 = Ref::findOne(['code' => $code, 'cat' => $cat])) !== null) {
            $model = Ref::find()->where(['param1' => $model2->id])->orderBy(['descr_en' => SORT_ASC])->all();
            if (!empty($model)) {
                foreach ($model as $row) {
                    $output .= '<option value="' . $row->code . '">' . $row->descr_en . '</option>';
                }
            }
        }
        return $output;
    }

    public function actionGetreflistmy($code, $cat) {
        $output = '<option value="">- Sila pilih -</option>';
        if (($model2 = Ref::findOne(['code' => $code, 'cat' => $cat])) !== null) {
            $model = Ref::find()->where(['param1' => $model2->id])->orderBy(['descr' => SORT_ASC])->all();
            if (!empty($model)) {
                foreach ($model as $row) {
                    $output .= '<option value="' . $row->code . '">' . $row->descr . '</option>';
                }
            }
        }
        return $output;
    }

}
