<?php

namespace backend\modules\fruserdynav2\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\modules\fruserdynav2\models\FrontendUser;

/**
 * FrontendUserSearch represents the model behind the search form of `backend\models\frontenduser\FrontendUser`.
 */
class FrontendUserSearch extends FrontendUser {

    /**
     * {@inheritdoc}
     */
    public function rules() {
        return [
            [['id', 'last_login', 'last_login_attempts', 'login_attempts', 'status', 'created_at', 'updated_at'], 'integer'],
            [['role', 'username', 'fullname', 'auth_key', 'password_hash', 'password_reset_token', 'email', 'created_by', 'updated_by', 'designation', 'department', 'department_en', 'branch'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios() {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params) {
        $query = FrontendUser::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'sort' => ['defaultOrder' => ['updated_at' => SORT_DESC]],
            'pagination' => ['pageSize' => 10],
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions

        $query->andFilterWhere(['like', 'frontend_user.username', $this->username]);
        $query->andFilterWhere(['like', 'frontend_user.fullname', $this->fullname]);
        $query->andFilterWhere(['=', 'frontend_user.role', $this->role]);
        $query->andFilterWhere(['=', 'frontend_user.branch', $this->branch]);

        return $dataProvider;
    }

}
