<?php

namespace backend\modules\fruserdynav2\models;

use Yii;

class ChangePassword extends \yii\db\ActiveRecord {

    public $old_password;
    public $new_password;
    public $repeat_password;
    private $_user;

    public static function tableName() {
        return 'frontend_user';
    }

    public function rules() {
        return [
            [['old_password', 'new_password', 'repeat_password'], 'required', 'message' => '{attribute} tidak boleh kosong'],
            ['old_password', 'validatePassword'],
            ['repeat_password', 'compare', 'compareAttribute' => 'new_password', 'message' => "{attribute} tidak sama dengan Kata Laluan Baru"],
        ];
    }

    public function attributeLabels() {
        return [
            'old_password' => Yii::t('app', 'Kata Laluan Lama'),
            'new_password' => Yii::t('app', 'Kata Laluan Baru'),
            'repeat_password' => Yii::t('app', 'Pengesahan Kata Laluan Baru'),
        ];
    }

    public function validatePassword($attribute, $params) {
        if (!$this->hasErrors()) {
            $user = $this->getUser();
            $getHashedPassword = self::find()->where(['id' => Yii::$app->user->identity->id])->one();
            $hashedPassword = $getHashedPassword->password_hash;
            if (!Yii::$app->getSecurity()->validatePassword($this->old_password, $hashedPassword)) {
                $this->addError($attribute, 'Kata Laluan Lama salah');
            }
        }
    }

    public function getUser() {
        if ($this->_user === false) {
            $this->_user = self::findByUsername(Yii::$app->user->identity->username);
        }
        return $this->_user;
    }

}
