<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\Pjax;
use yii\helpers\Url;
use backend\models\RosPertubuhanInduk;
use backend\models\frontenduser\FrontendUser;

/* @var $this yii\web\View */
/* @var $searchModel backend\models\frontenduser\FrontendUserSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = Yii::t('app', 'Frontend Users');
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="wrapper wrapper-content animated fadeInRight">
        <p>
            <?= Html::a('<i class="fa fa-plus"></i> ' . yii::t('app', 'Add User'), Url::to(['create']), ['class' => 'btn btn-success ']) ?>
        </p>
        <div class="ibox">
            <div class="mail-box b-r-md">
                <?php Pjax::begin(); ?>
                <?=
                GridView::widget([
                    'dataProvider' => $dataProvider,
                    'filterModel' => $searchModel,
                    'tableOptions' => ['class' => 'table'],
                    'summary' => '',
                    'columns' => [
                        // ['class' => 'yii\grid\SerialColumn'],
                        'username',
                        'fullname',
                        'email:email',
                        // 'department',
                        //'last_login',
                        //'last_login_attempts',
                        //'login_attempts',
                        [
                            'attribute' => 'status',
                            'format' => 'raw',
                            'value' => function($model) {
                                switch ($model->status) {
                                    case 'A':
                                        return '<label class="label label-primary">' .Yii::t('app', 'Active') . '</label>';
                                        break;

                                    case 'I':
                                        return '<label class="label label-danger">' .Yii::t('app', 'Inactive') . '</label>';
                                        break;
                                }
                            }
                        ],
                        [
                            'attribute' => 'role',
                            'value' => function($model) {
                                return $model->role;
                            }
                        ],
                        /* [
                          'attribute'=>'parent_id',
                          'value' => function($model){
                          return FrontendUser::getFrontendUserFromID($model->parent_id);

                          }
                          ], */
                        //'created_by',
                        //'created_at',
                        //'updated_by',
                        //'updated_at',
                        [
                            'class' => 'yii\grid\ActionColumn',
                            'contentOptions' => ['style' => 'white-space: nowrap;'],
                            'template' => '{update} {delete}'
                        ],
                    ],
                ]);
                ?>
                <?php Pjax::end(); ?>
            </div>
        </div>
    </div>
</div>
