<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use backend\modules\refdynawebv2\models\Ref;
use backend\modules\fruserdynav2\models\FrontendUser;
use backend\modules\mimin\models\UserSearch;
use yii\helpers\ArrayHelper;

/* @var $this yii\web\View */
/* @var $model backend\models\frontenduser\FrontendUser */
/* @var $form yii\widgets\ActiveForm */

/* extra assets */
$this->params['extra-asset']['JS'][] = 'plugins/pwstrength/pwstrength-bootstrap.min.js';
$this->params['extra-asset']['JS'][] = 'plugins/pwstrength/zxcvbn.js';

$this->registerJs(
        <<<JS
    $('#frontenduser-password').pwstrength({ 
        viewports: {
            verdict: ".pwstrength_viewport_verdict4"
        },
        common:{
            zxcvbn: true,
            zxcvbnTerms: ['P@ssw0rd'],
        }
    });

    $('#frontenduser-confirmpassword').change(function(){
        if(this.value != $('#frontenduser-password').val){
            toastr.error('Password are ');
        }
    });

    let pwd_field          = document.querySelectorAll('input.pma_password'),
        pwd_revealer       = [],
        pwd_revealer_label = [];
    
    for (let i = 0, limit = pwd_field.length; i < limit; ++i) {
      pwd_field[i].insertAdjacentHTML( 'afterend',
                                       '<input type="checkbox" id="pma_revealer-' + i + '" class="invisible" aria-hidden="true">' +
                                       '<label for="pma_revealer-' + i + '" class="glyphicon glyphicon-eye-open form-control-feedback" aria-hidden="true"></label>'
                                      );
      pwd_revealer[i]       = pwd_field[i].parentElement.querySelector('input#pma_revealer-' + i);
      pwd_revealer_label[i] = pwd_field[i].parentElement.querySelector('label[for="pma_revealer-' + i + '"]');
      pwd_revealer[i].setAttribute('style', 'position: absolute; left: -99999rem;');
      pwd_revealer_label[i].style.pointerEvents = 'auto';
      pwd_revealer[i].addEventListener('change', function() {
        switch (pwd_revealer[i].checked) {
          case true:
            pwd_field[i].setAttribute('type', 'text');
            pwd_revealer_label[i].classList.remove('glyphicon-eye-open');
            pwd_revealer_label[i].classList.add('glyphicon-eye-close');
          break;
          case false:
            pwd_field[i].setAttribute('type', 'password');
            pwd_revealer_label[i].classList.remove('glyphicon-eye-close');
            pwd_revealer_label[i].classList.add('glyphicon-eye-open');
          break;
        }
      });
}
JS
);

$this->registerJsFile('https://cdn.jsdelivr.net/npm/select2@4.1.0-beta.1/dist/js/select2.min.js', ['depends' => [\yii\web\JqueryAsset::className()]]);
$this->registerCssFile('https://cdn.jsdelivr.net/npm/select2@4.1.0-beta.1/dist/css/select2.min.css');

$this->registerJs("$('#frontenduser-email').change(function(){
    $('#frontenduser-username').val($(this).val());
});

$(document).ready(function() {
    $('#frontenduser-directory_id').select2();
});
");
?>
<style type="text/css">
    .progress{ margin-top: 25px; }
    .form-control-feedback{ right:16px; }
    .select2-container--default .select2-selection--single{
        border-radius: 1px !important;
        border: 1px solid #e5e6e7 !important;
        height:34px;padding-top:3px;
    }
</style>

<script>
    function selectdirectoryprofile(id) {
        $.ajax({
            url: "index.php?r=staff/staff/getdirectoryprofile",
            method: "POST",
            data: {"id": id},
            success: function (response) {
                var data_arr = response.split("<--->");
                var name = data_arr[0];
                var email = data_arr[1];
                var designation = data_arr[2];
                var department = data_arr[3];
                
                $("#frontenduser-email").val(email);
                $("#frontenduser-username").val(email);
                $("#frontenduser-fullname").val(name);
                $("#frontenduser-designation").val(designation);
                $("#frontenduser-department").val(department);
                
            },
        });
    }
</script>

<div class="wrapper wrapper-content animated fadeInRight">
    <div class="ibox float-e-margins">
        <div class="ibox-content">
            <div class="row">
                <div class="col-md-12" style="padding:20px">
                    <?php $form = ActiveForm::begin(['options' => ['class' => 'form-horizontal'], 'fieldConfig' => ['template' => '{label}<div class="col-md-6">{input}</div><br><div class="col-md-offset-2 col-md-5">{error}</div>']]); ?>

                    <?= $form->field($model, 'email', ['labelOptions' => ['class' => 'control-label col-md-2']])->textInput(['maxlength' => true]) ?>

                    <?= $form->field($model, 'username', ['labelOptions' => ['class' => 'control-label col-md-2']])->textInput(['maxlength' => true, 'readonly' => 'true']) ?>

                    <!--?= $form->field($model, 'registrant_id',['labelOptions' => ['class' => 'control-label col-md-2']])->textInput(['maxlength' => true]) ?-->

                    <?= $form->field($model, 'fullname', ['labelOptions' => ['class' => 'control-label col-md-2']])->textInput(['maxlength' => true]) ?>

                    <?= $form->field($model, 'password', ['labelOptions' => ['class' => 'control-label col-md-2']])->passwordInput(['value' => '', 'maxlength' => true, 'class' => 'form-control pma_password']) ?>

                    <div class="pwstrength_viewport_verdict4"></div>

                    <?= $form->field($model, 'designation', ['labelOptions' => ['class' => 'control-label col-md-2']])->textInput(['maxlength' => true]) ?>

                    <?= $form->field($model, 'department', ['labelOptions' => ['class' => 'control-label col-md-2']])->textInput(['maxlength' => true]) ?>

                    <!--?= $form->field($model, 'id_pertubuhan',['labelOptions' => ['class' => 'control-label col-md-2']])->dropDownList(RosPertubuhanInduk::getPertubuhan()) ?-->

                    <?= $form->field($model, 'role', ['labelOptions' => ['class' => 'control-label col-md-2']])->dropDownList(Ref::getList('FROLE')) ?>

                    <?= $form->field($model, 'status', ['labelOptions' => ['class' => 'control-label col-md-2']])->dropDownList(['A' => yii::t('app', 'Active'), 'I' => yii::t('app', 'Inactive')]) ?>

                    <hr>
                    <div class="col-md-8">
                        <div class="form-group pull-right">
                            <?= Html::a('<i class="fa fa-reply"></i> ' . Yii::t('app', 'Back'), ['index'], ['class' => 'btn btn-warning']) ?>
                            <?= Html::submitButton('<i class="fa fa-save"></i> ' . Yii::t('app', 'Save'), ['class' => 'btn btn-success']) ?>
                        </div>
                    </div>
                    <?php ActiveForm::end(); ?>
                </div>
            </div>
        </div>
    </div>            
</div>