<?php

namespace backend\modules\fruserdynav2\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\modules\fruserdynav2\models\FrontendUser;

/**
 * FrontendUserSearch represents the model behind the search form of `backend\models\frontenduser\FrontendUser`.
 */
class FrontendUserSearch extends FrontendUser
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'last_login', 'last_login_attempts', 'login_attempts', 'status', 'role', 'created_at', 'updated_at'], 'integer'],
            [['username','fullname', 'auth_key', 'password_hash', 'password_reset_token', 'email', 'created_by', 'updated_by','designation','department','designation_en','department_en'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = FrontendUser::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        /*
        $query->andFilterWhere([
            'id' => $this->id,
            'last_login' => $this->last_login,
            'last_login_attempts' => $this->last_login_attempts,
            'login_attempts' => $this->login_attempts,
            'status' => $this->status,
            'role' => $this->role,
            'id_pertubuhan' => $this->id_pertubuhan,
            'parent_id' => $this->parent_id,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ]);*/

        $query->andFilterWhere(['like', 'username', $this->username])
            ->andFilterWhere(['like', 'email', $this->email])
            ->andFilterWhere(['like', 'designation', $this->designation])
            ->andFilterWhere(['like', 'department', $this->department])
            ->andFilterWhere(['like', 'designation', $this->designation_en])
            ->andFilterWhere(['like', 'department', $this->department_en])
            ->andFilterWhere(['like', 'fullname', $this->fullname]);

        return $dataProvider;
    }
}
