<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\bootstrap\Modal;
use yii\helpers\Url;

/* @var $this yii\web\View */
/* @var $searchModel backend\models\data\DataDashboardSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$url = Url::to(['change-banner']);

$this->title = Yii::t('app', 'Dashboard');
$this->params['breadcrumbs'][] = 'Pusat Data';
$this->params['breadcrumbs'][] = $this->title;

$this->registerJsFile('https://cdnjs.cloudflare.com/ajax/libs/dropzone/5.7.1/min/dropzone.min.js', ['position'=> yii\web\View::POS_HEAD]);
$this->registerCssFile('https://cdnjs.cloudflare.com/ajax/libs/dropzone/5.7.1/min/dropzone.min.css');
$this->registerJs(<<<JS
    //dropzone.js
    Dropzone.autoDiscover = false;
    
    var myDropzone = new Dropzone("#zip", {
        acceptedFiles: 'image/*',
        url: "$url",
        paramName:"bannerImage[file]",
        maxFiles: 1,
        maxfilesexceeded: function(file) {
            this.removeAllFiles();
            this.addFile(file);
        },
        error: function(file, message) {
            $(file.previewElement).addClass("dz-error").find('.dz-error-message').text(message.message);
        },
        success: function(file, message) {
            // window.location.reload();
            \$('#info').removeClass('alert-info');
            \$('#info').addClass('alert-success');
            \$('#info').html('<i class="fa fa-check"></i> File has been Uploaded');

        }
    });

    $('#change-banner').click(()=>{
        $('#changebanner-modal').modal('show');
    })
JS
);
?>
<script type="text/javascript">
    Dropzone.autoDiscover = false;
</script>
<style>
.dropzone.dz-clickable {
    text-align:center;
}
</style>
<div class="wrapper wrapper-content">
        <div class="ibox float-e-margins">
            <div class="ibox-title"> <?= $this->render('_search', ['model' => $searchModel]); ?></div>
            <div class="ibox-content">
                <div class="table-responsive">
                    <?=
                    GridView::widget([
                        'dataProvider' => $dataProvider,
                        //'filterModel' => $searchModel,
                        'columns' => [
                            ['class' => 'yii\grid\SerialColumn'],
                            'title',
                            [
                                'attribute' => 'category',
                            ],
                            'sorting',
                            [
                                'class' => 'yii\grid\ActionColumn',
                                'template' => '{update}&nbsp;&nbsp;{delete}',
                                'contentOptions' => ['class' => 'text-center', 'width' => '1%'],
                                'header' => 'Tindakan'
                            ],
                        ],
                    ]);
                    ?>

                </div>
            </div>
        </div>
    </div>
</div>

<?php
/* start modal */
Modal::begin([
    'header' => Yii::t('app', '<h3>Change Banner</h3>'),
    'id' => 'changebanner-modal'
]);

echo '<div class="alert alert-info" id="info">' . Yii::t('app','Please upload image to change banner for the dashboard.') . '</div>';

echo Html::beginForm('#','post',['class'=>'dropzone','id' => 'zip']);
echo '<div class="dz-message" data-dz-message><i style="font-size:50px" class="fa fa-upload"></i><br><span>Upload file</span></div>';
echo Html::endForm();

Modal::end();?> 
