<?php

use yii\helpers\Html;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $searchModel backend\models\mtdc\CompanySearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = Yii::t('app', 'Dana MTDC - ' . $subcategory);
$this->params['breadcrumbs'][] = 'Dashboard';
$this->params['breadcrumbs'][] = $this->title;

$this->registerJsFile("https://code.jquery.com/jquery-3.1.1.min.js", ['depends' => [\yii\web\JqueryAsset::className()]]);
$this->registerJsFile("https://code.highcharts.com/highcharts.js", ['depends' => [\yii\web\JqueryAsset::className()]]);
$this->registerJsFile("https://code.highcharts.com/highcharts-3d.js", ['depends' => [\yii\web\JqueryAsset::className()]]);
$this->registerJsFile("https://code.highcharts.com/modules/exporting.js", ['depends' => [\yii\web\JqueryAsset::className()]]);
$this->registerJsFile("https://code.highcharts.com/modules/export-data.js", ['depends' => [\yii\web\JqueryAsset::className()]]);
$this->registerJsFile("https://code.highcharts.com/modules/accessibility.js", ['depends' => [\yii\web\JqueryAsset::className()]]);
$this->registerJsFile("https://code.highcharts.com/modules/cylinder.js", ['depends' => [\yii\web\JqueryAsset::className()]]);

$fundTypeArr = \backend\models\Ref::find()->where(['cat' => 'SYSTEMLIST'])->orderBy(['sort' => SORT_ASC])->all();
?>
<style>
    .btn-custom{
        margin-right:0.2em;
        text-align:center;
        width:130px;
        margin-bottom:0.2em;
    }
</style>
<div class="wrapper wrapper-content animated fadeInRight">
    <?php
    $countFund = 0;
    if (!empty($fundTypeArr)) {
        foreach ($fundTypeArr as $type) {
            $countFund++;
            if ($subcategory == $type['code'])
                $btn_color = "btn-danger";
            else
                $btn_color = "btn-success";
            echo '<a href="index.php?r=data%2Fdata-dashboard%2Ffund&subcategory=' . $type['code'] . '" class="btn-custom btn ' . $btn_color . ' btn-pill">
                    ' . $countFund . '. ' . $type['descr'] . '
                </a>';
        }
    }
    ?>

    <div class="row">
        <?php
        if (!empty($model)) {
            foreach ($model as $row) {
                echo '<div class="col-md-6" style="margin-top:2em;">';
                eval("?>" . $row->content);
                echo '</div>';
            }
        }
        ?>
    </div>
</div>