<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use common\assets\AceEditorAsset;

AceEditorAsset::register($this);

$this->registerJs("changecategory()");

$this->registerJs(
    <<<JS
var textarea = $('#datadashboard-content').hide();
var editor = ace.edit('editorContent');
    editor.setOptions({
        maxLines: Infinity,
    });
    editor.setTheme("ace/theme/monokai");
    //editor.\$blockScrolling = Infinity;
    editor.getSession().setMode("ace/mode/php");
    editor.getSession().setValue(textarea.val());
    editor.getSession().on('change', function () {
        textarea.val(editor.getSession().getValue());
    });
JS
);
?>
<style type="text/css" media="screen">
    .ace_editor  { min-height:300px; z-index:9999; }
    .ace_text-input{  position:absolute!important }
    #editorContent{margin-bottom:2em;}
    .field-dashboard-content{margin:0 !important;}
    .field-dashboard-content .help-block{margin:0 !important;}
</style>
<div class="data-dashboard-form">
    <div class="wrapper wrapper-content animated fadeInRight">
        <div class="ibox float-e-margins">
            <div class="ibox-content">
                <?php $form = ActiveForm::begin(); ?>
                <div class="row">
                    <div class="col-sm-3"><?= $form->field($model, 'title')->textInput(['maxlength' => true]) ?></div>
                    <div class="col-sm-3"><?= $form->field($model, 'sorting')->textInput() ?></div>
                    <div class="col-sm-3">
                        <?=
                        $form->field($model, 'category')->dropdownList(
                            ['homepage' => 'Laman Utama',],
                            ['prompt' => '- Sila pilih - ','onchange' => 'changecategory()']
                        )
                        ?>
                    </div>
                    <div class="col-sm-3">
                        <div id="subcategory-wrapper">
                            <?php /*=
                            $form->field($model, 'subcategory')->dropdownList(ArrayHelper::map(\backend\models\Ref::find()->where(['cat' => 'SYSTEMLIST'])->orderBy(['descr' => SORT_ASC])->all(), 'code', 'descr'), [
                                'prompt' => '- Sila pilih - '])*/
                            ?>
                        </div>
                    </div>
                </div>
                <?= $form->field($model, 'content')->textarea(['rows' => 6]) ?>
                <div id="editorContent"></div>

                <div class="form-group">
                    <?= Html::a(Yii::t('app', "<i class=\"fa fa-arrow-left\"></i> " . 'Kembali'), ['index'], ['class' => 'btn btn-primary']) ?>
                    <?= Html::submitButton(Yii::t('app', 'Simpan'), ['class' => 'btn btn-success']) ?>
                </div>
                <?php ActiveForm::end(); ?>
            </div>
        </div>
    </div>
</div>
<script>
    function changecategory() {
        var category = $('#datadashboard-category').val();
        if (category === 'fund')
            $('#subcategory-wrapper').show();
        else
            $('#subcategory-wrapper').hide();
    }
</script>