<?php

namespace backend\modules\customDashboard\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\modules\customDashboard\models\DataDashboard;

/**
 * DataDashboardSearch represents the model behind the search form of `backend\models\data\DataDashboard`.
 */
class DataDashboardSearch extends DataDashboard {

    /**
     * {@inheritdoc}
     */
    public function rules() {
        return [
            [['id', 'sorting', 'activation_status', 'created_by', 'updated_by'], 'integer'],
            [['title', 'content', 'category', 'subcategory', 'created_at', 'updated_at'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios() {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params) {
        $query = DataDashboard::find();

        // add conditions that should always apply here
        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'sort' => ['defaultOrder' => ['updated_at' => SORT_DESC]],
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere(['like', 'title', $this->title])
                ->andFilterWhere(['like', 'content', $this->content]);
        
         $query->andWhere(['=', 'activation_status', 1]);

        return $dataProvider;
    }

}
