<?php

namespace backend\modules\customDashboard\models;

use Yii;
use yii\behaviors\TimestampBehavior;
use yii\behaviors\BlameableBehavior;
use yii\db\Expression;
use yii\db\ActiveRecord;
use asinfotrack\yii2\audittrail\behaviors\AuditTrailBehavior;

/**
 * This is the model class for table "data_dashboard".
 *
 * @property int $id
 * @property string $title
 * @property string $content
 * @property string $category
 * @property string $subcategory
 * @property int $sorting
 * @property int $activation_status
 * @property int $created_by
 * @property string $created_at
 * @property int $updated_by
 * @property string $updated_at
 */
class DataDashboard extends \yii\db\ActiveRecord {

    /**
     * {@inheritdoc}
     */
    public static function tableName() {
        return 'data_dashboard';
    }
    
    public function behaviors() {
        return [
            'audittrail' => [
                'class' => AuditTrailBehavior::className(),
                // some of the optional configurations
                'ignoredAttributes' => ['created_at', 'updated_at'],
                'consoleUserId' => 1,
                'attributeOutput' => [
                    'desktop_id' => function ($value) {
                        $model = Desktop::findOne($value);
                        return sprintf('%s %s', $model->manufacturer, $model->device_name);
                    },
                    'last_checked' => 'datetime',
                ],
            ],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function rules() {
        return [
            [['title', 'content', 'category'], 'required'],
            [['content'], 'string'],
            [['sorting', 'activation_status', 'created_by', 'updated_by'], 'integer'],
            [['created_at', 'updated_at'], 'safe'],
            [['title', 'category', 'subcategory'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels() {
        return [
            'id' => Yii::t('app', 'ID'),
            'title' => Yii::t('app', 'Tajuk'),
            'content' => Yii::t('app', 'Kandungan'),
            'sorting' => Yii::t('app', 'Susunan'),
            'category' => Yii::t('app', 'Kategori'),
            'subcategory' => Yii::t('app', 'Subkategori'),
            'activation_status' => Yii::t('app', 'Activation Status'),
            'created_by' => Yii::t('app', 'Created By'),
            'created_at' => Yii::t('app', 'Created At'),
            'updated_by' => Yii::t('app', 'Updated By'),
            'updated_at' => Yii::t('app', 'Updated At'),
        ];
    }

}
