<?php

namespace backend\modules\customDashboard\controllers;

use Yii;
use backend\modules\customDashboard\models\DataDashboard;
use backend\modules\customDashboard\models\DataDashboardSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use common\components\AccessRule;
use common\components\HelpersFunctions;

/**
 * DataDashboardController implements the CRUD actions for DataDashboard model.
 */
class DataDashboardController extends Controller {

    /**
     * {@inheritdoc}
     */
    public function behaviors() {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'ruleConfig' => [
                    'class' => AccessRule::className(),
                ],
                'rules' => [
                    [
                        'actions' => ['index', 'create', 'update', 'view', 'delete', 'category', 'change-banner'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    public function actionCategory($cat) {
        $model = DataDashboard::find()
                ->where(['activation_status' => '1'])
                ->andwhere(['category' => $cat])
                ->orderBy(['sorting' => SORT_ASC])
                ->all();
        return $this->render('dashboard', ['model' => $model]);
    }
    
    public function actionInprogress() {
        return $this->render('inprogress');
    }

    /**
     * Lists all DataDashboard models.
     * @return mixed
     */
    public function actionIndex() {
        $searchModel = new DataDashboardSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
                    'searchModel' => $searchModel,
                    'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single DataDashboard model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id) {
        return $this->render('view', [
                    'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new DataDashboard model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate() {
        $model = new DataDashboard();
        $model->created_at = date("Y-m-d H:i:s");
        $model->created_by = Yii::$app->user->identity->id;
        $model->updated_at = date("Y-m-d H:i:s");
        $model->updated_by = Yii::$app->user->identity->id;
        $model->activation_status = 1;
        //$model->sorting = (int) Dashboard::find()->count() + 1;
        $model->content = "<?php ";
        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['index']);
        }
        return $this->render('create', ['model' => $model,]);
    }

    /**
     * Updates an existing DataDashboard model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id) {
        $model = $this->findModel($id);
        $model->updated_at = date("Y-m-d H:i:s");
        $model->updated_by = Yii::$app->user->identity->id;
        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['index']);
        }
        return $this->render('update', ['model' => $model,]);
    }

    /**
     * Deletes an existing DataDashboard model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id) {
        $model = $this->findModel($id);
        $model->updated_at = date("Y-m-d H:i:s");
        $model->updated_by = Yii::$app->user->identity->id;
        $model->activation_status = 0;
        if ($model->save()) {
            return $this->redirect(['index']);
        }
    }

    /**
     * Finds the DataDashboard model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return DataDashboard the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id) {
        if (($model = DataDashboard::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
    }

    public function actionChangeBanner() {
        if ($_FILES['bannerImage']['error']['file'] === 0) {
            $path = 'images';
            $filename = 'cmsbanner.jpg';
            $source = $_FILES['bannerImage']['tmp_name']['file'];
            //compress it
            HelpersFunctions::compressImage($source, $path, $filename, 75);
        }

        return $this->asJson([
            'success' => true
        ]);
    }

}
