<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\helpers\ArrayHelper;
use backend\modules\contentTender\models\ContentTenderTranslation;

/* @var $this yii\web\View */
/* @var $searchModel backend\modules\contentTender\models\ContentTenderSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = Yii::t('app', 'Tender');
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="wrapper wrapper-content">
    <p>
        <?= Html::a(Yii::t('app', 'Create Tender'), ['create'], ['class' => 'btn btn-primary']) ?>
        <?= Html::a(Yii::t('app', 'API Tender List'), ['/api/api/view?api_code=ContentTenderList'], ['class' => 'btn btn-primary', 'target' => '_blank']) ?>
        <?= Html::a(Yii::t('app', 'API Tender Details'), ['/api/api/view?api_code=ContentTenderDetails'], ['class' => 'btn btn-primary', 'target' => '_blank']) ?>
    </p>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>
    <div class="ibox animated fadeInRight">
        <div class="mail-box b-r-md">
            <?=
            GridView::widget([
                'dataProvider' => $dataProvider,
                'filterModel' => $searchModel,
                'tableOptions' => ['class' => 'table',],
                'summary' => '',
                'columns' => [
                    ['class' => 'yii\grid\SerialColumn'],
                    [
                        'attribute' => 'tender_title',
                        'value' => function ($model) {
                            if (($modeltranslation = ContentTenderTranslation::findOne(['tender_translation_parent_id' => $model->tender_id, 'tender_translation_main' => 1])) !== null) {
                                return $modeltranslation->tender_translation_title;
                            }
                        }
                    ],
                    [
                        'attribute' => 'tender_category',
                        'headerOptions' => ['style' => 'width:10%'],
                        'filter' => ArrayHelper::map(
                                (new \yii\db\Query())->select(['code', 'descr'])
                                        ->from('ref')
                                        ->where(['=', 'cat', 'TENDERCATEGORY'])
                                        ->orderBy(['sort' => SORT_ASC])
                                        ->all(), 'code', 'descr'),
                        'value' => function ($model) {
                            $ref = (new \yii\db\Query())->select(['descr'])
                                    ->from('ref')
                                    ->where(['=', 'cat', 'TENDERCATEGORY'])
                                    ->andwhere(['=', 'code', $model->tender_category])
                                    ->one();
                            if (!empty($ref))
                                return $ref['descr'];
                        }
                    ], 
                    [
                        'attribute' => 'tender_status',
                        'headerOptions' => ['style' => 'width:10%'],
                        'filter' => ArrayHelper::map(
                                (new \yii\db\Query())->select(['code', 'descr'])
                                        ->from('ref')
                                        ->where(['=', 'cat', 'TENDERSTATUS'])
                                        ->orderBy(['sort' => SORT_ASC])
                                        ->all(), 'code', 'descr'),
                        'value' => function ($model) {
                            $ref = (new \yii\db\Query())->select(['descr'])
                                    ->from('ref')
                                    ->where(['=', 'cat', 'TENDERSTATUS'])
                                    ->andwhere(['=', 'code', $model->tender_status])
                                    ->one();
                            if (!empty($ref))
                                return $ref['descr'];
                        }
                    ],
                    [
                        'attribute' => 'tender_file',
                        'headerOptions' => ['style' => 'width:10%'],
                        'value' => function ($model) {
                            if(!empty($model->tender_file))
                                return '<a href="'.Yii::getAlias('@web') .'/'.$model->tender_file. '" target="_blank"><i class="fa fa-download" aria-hidden="true"></i></a> ';
                            else
                                return '';
                        },
                        'format' => 'raw',
                    ],
                    [
                        'header' => 'Language',
                        'format' => 'raw',
                        'headerOptions' => ['style' => 'width:10%'],
                        'value' => function ($model) {
                            $output = '';
                            $arr = ArrayHelper::map(
                                            (new \yii\db\Query())->select(['*'])
                                                    ->from('content_tender_translation')
                                                    ->orderBy(['tender_translation_language' => SORT_ASC])
                                                    ->groupby(['tender_translation_language'])
                                                    ->all(), 'tender_translation_language', 'tender_translation_language');
                            if (!empty($arr)) {
                                foreach ($arr as $code) {
                                    $ref = (new \yii\db\Query())->select(['descr'])
                                            ->from('ref')
                                            ->where(['=', 'cat', 'TENDERLANGUAGE'])
                                            ->andwhere(['=', 'code', $code])
                                            ->one();
                                    if (!empty($ref)) {
                                        $label_class = 'label-dark';
                                        if (($modeltranslation = ContentTenderTranslation::findOne(['tender_translation_parent_id' => $model->tender_id, 'tender_translation_language' => $code])) !== null) {
                                            $label_class = 'label-primary';
                                        }
                                        $output .= '<span class="label ' . $label_class . '">' . $ref['descr'] . '</span>&nbsp;&nbsp;';
                                    }
                                }
                            }
                            return $output;
                        }
                    ],
                    [
                        'class' => 'yii\grid\ActionColumn',
                        'header' => 'Action',
                        'template' => '{update} {delete}',
                        'headerOptions' => ['style' => 'text-align:center;width:10%'],
                        'contentOptions' => ['style' => 'text-align:center;'],
                    ],
                ],
            ]);
            ?>
        </div>
    </div>
</div>
