<?php

use mihaildev\ckeditor\CKEditor;
use mihaildev\elfinder\ElFinder;
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use kartik\file\FileInput;
use backend\modules\contentTender\models\ContentTenderTranslation;

/* @var $this yii\web\View */
/* @var $model backend\modules\contentTender\models\ContentTender */
/* @var $form yii\widgets\ActiveForm */
$this->registerCssFile('@web/plugins/summernote/summernote.min.css');
$this->registerJsFile('@web/plugins/summernote/summernote.min.js', ['depends' => [\yii\web\JqueryAsset::className()]]);
$this->registerCssFile('@web/plugins/bootstrap-tagsinput/dist/bootstrap-tagsinput.css');
$this->registerJsFile('@web/plugins/bootstrap-tagsinput/dist/bootstrap-tagsinput.min.js', ['depends' => [\yii\web\JqueryAsset::className()]]);

$this->registerJs(
        <<<JS
    $('#contenttender-tender_date_start').datepicker({'format':'yyyy-mm-dd'});
    $('#contenttender-tender_date_end').datepicker({'format':'yyyy-mm-dd'});
    $('.summernote').summernote({height: 300});
JS
);
$this->registerCss(".note-editor{border:1px solid #e5e6e7 !important}
    .bootstrap-tagsinput input, .bootstrap-tagsinput {width:100% !important;}");
?>
<?php $form = ActiveForm::begin(); ?>
<div class="wrapper wrapper-content animated fadeInRight" style="padding: 20px 10px 20px;">
    <div class="ibox float-e-margins">
        <div class="ibox-content">
            <div class="row">
                <div class="col-sm-6">
                    <?=
                    $form->field($model, 'tender_category')->dropdownList(
                            ArrayHelper::map(
                                    (new \yii\db\Query())->select(['code', 'descr'])
                                            ->from('ref')
                                            ->where(['=', 'cat', 'TENDERCATEGORY'])
                                            ->orderBy(['sort' => SORT_ASC])
                                            ->all(), 'code', 'descr'), [
                        'maxlength' => true, 'onchange' => 'changecategory(this.value)', 'prompt' => '-- Please choose --'])
                    ?>
                </div>
                <div class="col-sm-6">
                    <?=
                    $form->field($model, 'tender_status')->dropdownList(
                            ArrayHelper::map(
                                    (new \yii\db\Query())->select(['code', 'descr'])
                                            ->from('ref')
                                            ->where(['=', 'cat', 'TENDERSTATUS'])
                                            ->orderBy(['sort' => SORT_ASC])
                                            ->all(), 'code', 'descr'), [
                        'maxlength' => true,])
                    ?>
                </div>
            </div>
            <div class="row">
                <div class="col-sm-4"><?= $form->field($model, 'tender_date_start')->textInput() ?></div>
                
                <div class="col-sm-4"><?= $form->field($model, 'tender_date_end')->textInput() ?></div>

                <div class="col-sm-4"><?= $form->field($model, 'tender_sorting')->textInput() ?></div>
            </div>
            <?php
            $img_url = Yii::getAlias('@web') . '/images/noimage.jpg';
            if (!empty($model->tender_image)) {
                echo $form->field($model, 'tender_image')->widget(FileInput::classname(), [
                    'options' => ['accept' => 'image/*'],
                    'pluginOptions' => [
                        'showUpload' => false,
                        'initialPreview' => [
                            '<img style="width:100%" src="' . Yii::getAlias('@web') . '/' . $model->tender_image . '"/>',
                        ],
                    ]
                ]);
            } else {
                echo $form->field($model, 'tender_image')->widget(FileInput::classname(), [
                    'options' => ['accept' => 'image/*'],
                ]);
            }
            ?>
            <?php
            $files_url = Yii::getAlias('@web') . '/files/nofile.jpg';
            if (!empty($model->tender_file)) {
                $name = substr($model->tender_file, 14);
                echo $form->field($model, 'tender_file')->widget(FileInput::classname(), [
                    'options' => ['accept' => 'file/*'],
                    'pluginOptions' => [
                        'showUpload' => false,
                        'initialPreview' => [
                            '<a href="' . Yii::getAlias('@web') . '/' . $model->tender_file . '" target="_blank" ><i class="fa fa-folder-open" aria-hidden="true" style="font-size: 30px;"></i></a>',
                        ],
                    ]
                ]);
            } else {
                echo $form->field($model, 'tender_file')->widget(FileInput::classname(), [
                    'options' => ['accept' => 'file/*'],
                ]);
            }
            ?>
        </div>
    </div>

    <div class="ibox float-e-margins">
        <div class="ibox-content">
            <div class="row">
                <div class="col-sm-4">
                    <?=
                    $form->field($model, 'tender_language')->dropdownList(
                            ArrayHelper::map(
                                    (new \yii\db\Query())->select(['code', 'descr'])
                                            ->from('ref')
                                            ->where(['=', 'cat', 'TENDERLANGUAGE'])
                                            ->orderBy(['sort' => SORT_ASC])
                                            ->all(), 'code', 'descr'), [
                        'maxlength' => true,])
                    ?>
                </div>
                <div class="col-sm-8"><?= $form->field($model, 'tender_title')->textInput() ?></div>
            </div>


            <?= $form->field($model, 'tender_content')->textarea(['class' => 'summernote']) ?>            
        </div> 
    </div>
    <?php
    $modeltranslation = ContentTenderTranslation::find()
                    ->where(['=', 'tender_translation_parent_id', $model->tender_id])
                    ->andwhere(['=', 'tender_translation_main', '0'])
                    ->orderBy(['tender_translation_id' => SORT_ASC])->all();
    if (!empty($modeltranslation)) {
        foreach ($modeltranslation as $rowtranslation) {
            echo '<div class="ibox float-e-margins" id="old-translation-' . $rowtranslation->tender_translation_id . '">
            <input type="hidden" name="oldtranslation[]" value="' . $rowtranslation->tender_translation_id . '">
            <div class="ibox-title">
                <button type="button" class="btn btn-primary btn-sm" onclick="deleteoldtranslation(' . $rowtranslation->tender_translation_id . ')">Delete</button>&nbsp;&nbsp;&nbsp;
                Tender Translation
            </div>
            <div class="ibox-content">
                <div class="row">
                    <div class="col-sm-4">
                        <div class="form-group">
                            <label>Language</label>
                            ' . Html::dropDownList('old_language_' . $rowtranslation->tender_translation_id, $rowtranslation->tender_translation_language, ArrayHelper::map(
                            (new \yii\db\Query())->select(['code', 'descr'])
                                    ->from('ref')
                                    ->where(['=', 'cat', 'TENDERLANGUAGE'])
                                    ->orderBy(['sort' => SORT_ASC])
                                    ->all(), 'code', 'descr'), [
                'class' => 'form-control',]) . '
                        </div>
                    </div>
                    <div class="col-sm-8">
                        <div class="form-group">
                            <label>Title</label>
                            <input type="text" class="form-control" name="old_title_' . $rowtranslation->tender_translation_id . '" value="' . $rowtranslation->tender_translation_title . '">
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <label>Content</label>
                    <textarea class="summernote" name="old_content_' . $rowtranslation->tender_translation_id . '">' . $rowtranslation->tender_translation_content . '</textarea>
                </div>
            </div>
        </div>';
        }
    }
    ?>
    <div id="wrapper-translation"></div>

    <div class="form-group">
        <?= Html::submitButton($model->isNewRecord ? 'Create' : 'Update', ['class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary']) ?>
        <?php
        if (!$model->isNewRecord)
            echo Html::button('Add Translation', ['class' => 'btn btn-primary', 'onclick' => 'addtranslation()']);
        ?>
    </div>
</div>
<?php ActiveForm::end(); ?>
<script>
    function changecategory(parent_code) {
        $.ajax({
            url: "getsubcategory?parent_code=" + parent_code,
            method: "GET",
            success: function (response) {
                $('#contenttender-tender_subcategory').find('option').not(':first').remove();
                $('#contenttender-tender_subcategory').append(response);
            },
        });
    }

    var newcount = 1;
    function addtranslation() {
        newcount++;
        $.ajax({
            url: "addtranslation?no=" + newcount,
            method: "GET",
            success: function (response) {
                $('#wrapper-translation').append(response);
                $('.summernote').summernote({height: 300});
            },
        });
    }

    function deletenewtranslation(no) {
        $('#new-translation-' + no).remove();
    }

    function deleteoldtranslation(id) {
        var r = confirm("Are you sure to delete this data?");
        if (r == true) {
            $.ajax({
                url: "deletetranslation?id=" + id,
                method: "GET",
                success: function (response) {
                    $('#old-translation-' + id).remove();
                },
            });
        }
    }
</script>