CREATE TABLE IF NOT EXISTS `content_tender` (
  `tender_id` int(11) NOT NULL AUTO_INCREMENT,
  `tender_date_start` date DEFAULT NULL,
  `tender_date_end` date DEFAULT NULL,
  `tender_category` varchar(255) DEFAULT NULL,
  `tender_status` varchar(255) DEFAULT NULL,
  `tender_sorting` int(11) DEFAULT NULL,
  `tender_image` varchar(255) DEFAULT NULL,
  `tender_file` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`tender_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `content_tender_translation` (
  `tender_translation_id` int(11) NOT NULL AUTO_INCREMENT,
  `tender_translation_parent_id` int(11) DEFAULT NULL,
  `tender_translation_title` text CHARACTER SET utf8mb4 DEFAULT NULL,
  `tender_translation_content` text CHARACTER SET utf8mb4 DEFAULT NULL,
  `tender_translation_main` int(11) DEFAULT NULL,
  `tender_translation_language` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`tender_translation_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `ref` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cat` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `code` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `descr` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `descr_en` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sort` int(11) DEFAULT NULL,
  `param1` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `icon_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_by` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_at` int(11) DEFAULT NULL,
  `updated_by` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `updated_at` int(11) DEFAULT NULL,
  `deleted_at` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

insert  into `ref`(`cat`,`code`,`descr`,`descr_en`,`sort`,`param1`,`icon_name`,`created_by`,`created_at`,`updated_by`,`updated_at`,`deleted_at`) values 
('TENDERSTATUS','active','Active',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('TENDERSTATUS','inactive','Inactive',NULL,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('TENDERSTATUS','archived','Archived',NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('TENDERCATEGORY','tendercategory01','Main Tender',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('TENDERLANGUAGE','Malay','Malay',NULL,7,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('TENDERLANGUAGE','Chinese','Chinese',NULL,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('TENDERLANGUAGE','English','English',NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('TENDERLANGUAGE','Hindi','Hindi',NULL,4,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('TENDERLANGUAGE','Arabic','Arabic',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('TENDERLANGUAGE','Japanese','Japanese',NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('TENDERLANGUAGE','Tamil','Tamil',NULL,8,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('TENDERLANGUAGE','Korean','Korean',NULL,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL);

CREATE TABLE IF NOT EXISTS `api` (
  `api_id` int(11) NOT NULL AUTO_INCREMENT,
  `api_code` varchar(255) DEFAULT NULL,
  `api_descr` text DEFAULT NULL,
  `api_content` text DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`api_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

insert  into `api`(`api_code`,`api_descr`,`api_content`,`created_at`,`created_by`,`updated_at`,`updated_by`) values 
('ContentTenderList','This is the API to display all the list of tender','<?php \r\n\r\n$sql = \"SELECT * FROM content_tender_translation t1 \r\n    INNER JOIN content_tender t2 ON t1.tender_translation_parent_id=t2.tender_id\";\r\n$model = Yii::$app->db->createCommand($sql)->queryAll();\r\n$arr = [];\r\n$status = \'failed\';\r\nif(!empty($model)){\r\n    foreach($model as $row){\r\n        $status = \'success\';\r\n        $arr2 = [];\r\n        $arr2[\'language\'] = $row[\'tender_translation_language\'];\r\n        $arr2[\'title\'] = $row[\'tender_translation_title\'];\r\n        $arr2[\'content\'] = $row[\'tender_translation_content\'];\r\n        \r\n        $arr2[\'category\'] = $row[\'tender_category\'];\r\n        $arr2[\'status\'] = $row[\'tender_status\'];\r\n        $arr2[\'date_start\'] = $row[\'tender_date_start\'];\r\n        $arr2[\'date_end\'] = $row[\'tender_date_end\'];\r\n        $arr2[\'sorting\'] = $row[\'tender_sorting\'];\r\n        $arr2[\'pdf\'] = $row[\'tender_file\'];\r\n        $arr2[\'thumbnail\'] = $row[\'tender_image\'];\r\n        \r\n        $arr[] = $arr2;\r\n    }\r\n}\r\necho json_encode([\'result_status\'=>$status,\'data\'=>$arr]);',NOW(),3,NOW(),3),
('ContentTenderDetails','This is the API to display the details of the tender','<?php \r\n$tender_id = \'\';\r\n$arr = [];\r\n$status = \'failed\';\r\n$remark = \'\';\r\nif(isset($_GET[\'tender_id\'])&&!empty($_GET[\'tender_id\'])){\r\n    $tender_id = $_GET[\'tender_id\'];\r\n    $sql = \"SELECT * FROM content_tender_translation t1 \r\n        INNER JOIN content_tender t2 ON t1.tender_translation_parent_id=t2.tender_id WHERE t2.tender_id=\".$tender_id;\r\n    $model = Yii::$app->db->createCommand($sql)->queryAll();\r\n    \r\n    if(!empty($model)){\r\n        foreach($model as $row){\r\n            $status = \'success\';\r\n            $arr2 = [];\r\n            $arr2[\'language\'] = $row[\'tender_translation_language\'];\r\n            $arr2[\'title\'] = $row[\'tender_translation_title\'];\r\n            $arr2[\'content\'] = $row[\'tender_translation_content\'];\r\n            \r\n            $arr2[\'category\'] = $row[\'tender_category\'];\r\n            $arr2[\'status\'] = $row[\'tender_status\'];\r\n            $arr2[\'date_start\'] = $row[\'tender_date_start\'];\r\n            $arr2[\'date_end\'] = $row[\'tender_date_end\'];\r\n            $arr2[\'sorting\'] = $row[\'tender_sorting\'];\r\n            $arr2[\'pdf\'] = $row[\'tender_file\'];\r\n            $arr2[\'thumbnail\'] = $row[\'tender_image\'];\r\n            \r\n            $arr[] = $arr2;\r\n        }\r\n    }else{\r\n        $remark = \'Record not found\';\r\n    }\r\n    \r\n}else{\r\n    $remark = \'Please specify the tender_id using $_GET method\';\r\n}\r\necho json_encode([\'result_status\'=>$status,\'remark\'=>$remark,\'data\'=>$arr]);',NOW(),3,NOW(),3);

insert  into `backend_menu`(`menu_name`,`menu_param`,`menu_class`,`menu_link`,`menu_active_route`,`menu_parent_id`,`menu_status`) values 
('Tender','','fa fa-file-text-o','/contentTender/content-tender/index','',0,1);

insert  into `route`(`name`,`alias`,`type`,`status`) values ('/contentTender/content-tender/index','index','contentTender/content-tender',1);