<?php

namespace backend\modules\contentTender\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\modules\contentTender\models\ContentTenderTranslation;

/**
 * ContentTenderTranslationSearch represents the model behind the search form of `backend\modules\contentTender\models\ContentTenderTranslation`.
 */
class ContentTenderTranslationSearch extends ContentTenderTranslation
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['tender_translation_id', 'tender_translation_parent_id', 'created_by', 'updated_by'], 'integer'],
            [['tender_translation_title', 'tender_translation_content', 'tender_translation_tag', 'created_at', 'updated_at'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = ContentTenderTranslation::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'tender_translation_id' => $this->tender_translation_id,
            'tender_translation_parent_id' => $this->tender_translation_parent_id,
            'created_at' => $this->created_at,
            'created_by' => $this->created_by,
            'updated_at' => $this->updated_at,
            'updated_by' => $this->updated_by,
        ]);

        $query->andFilterWhere(['like', 'tender_translation_title', $this->tender_translation_title])
            ->andFilterWhere(['like', 'tender_translation_content', $this->tender_translation_content])
            ->andFilterWhere(['like', 'tender_translation_tag', $this->tender_translation_tag]);

        return $dataProvider;
    }
}
