<?php

namespace backend\modules\contentTender\models;

use Yii;

/**
 * This is the model class for table "content_tender_translation".
 *
 * @property int $tender_translation_id
 * @property int|null $tender_translation_parent_id
 * @property string|null $tender_translation_title
 * @property string|null $tender_translation_content
 * @property string|null $tender_translation_tag
 * @property string|null $created_at
 * @property int|null $created_by
 * @property string|null $updated_at
 * @property int|null $updated_by
 */
class ContentTenderTranslation extends \yii\db\ActiveRecord {

    /**
     * {@inheritdoc}
     */
    public static function tableName() {
        return 'content_tender_translation';
    }

    /**
     * {@inheritdoc}
     */
    public function rules() {
        return [
            [['tender_translation_parent_id', 'created_by', 'updated_by', 'tender_translation_main'], 'integer'],
            [['tender_translation_title', 'tender_translation_content', 'tender_translation_language'], 'string'],
            [['created_at', 'updated_at'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels() {
        return [
            'tender_translation_id' => Yii::t('app', 'Tender Translation ID'),
            'tender_translation_parent_id' => Yii::t('app', 'Tender Translation Parent ID'),
            'tender_translation_title' => Yii::t('app', 'Tender Translation Title'),
            'tender_translation_content' => Yii::t('app', 'Tender Translation Content'),
            'tender_translation_language' => Yii::t('app', 'Tender Translation Language'),
            'created_at' => Yii::t('app', 'Created At'),
            'created_by' => Yii::t('app', 'Created By'),
            'updated_at' => Yii::t('app', 'Updated At'),
            'updated_by' => Yii::t('app', 'Updated By'),
        ];
    }

}
