<?php

namespace backend\modules\contentTender\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\modules\contentTender\models\ContentTender;

/**
 * ContentTenderSearch represents the model behind the search form of `backend\modules\contentTender\models\ContentTender`.
 */
class ContentTenderSearch extends ContentTender {

    public $tender_title;
    public $tender_content;

    /**
     * {@inheritdoc}
     */
    public function rules() {
        return [
            [['tender_id', 'tender_sorting', 'created_by', 'updated_by'], 'integer'],
            [['tender_category', 'tender_status', 'tender_image', 'tender_content', 'tender_file', 'created_at', 'updated_at', 'tender_title'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios() {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params) {
        $query = ContentTender::find()
                ->innerJoin('content_tender_translation', 'content_tender_translation.tender_translation_parent_id=content_tender.tender_id')
                ->where(['=', 'content_tender_translation.tender_translation_main', '1']);

        // add conditions that should always apply here
        $dataProvider = new ActiveDataProvider(['query' => $query, 'pagination' => ['pageSize' => 10,]]);
        $dataProvider->setSort(['defaultOrder' => ['updated_at' => SORT_DESC]]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere(['=', 'tender_category', $this->tender_category]);
        $query->andFilterWhere(['=', 'tender_status', $this->tender_status]);
        $query->andFilterWhere(['LIKE', 'tender_translation_title', $this->tender_title]);
        $query->andFilterWhere(['LIKE', 'tender_translation_content', $this->tender_content]);


        return $dataProvider;
    }

}
