<?php

namespace backend\modules\contentTender\models;

use Yii;

/**
 * This is the model class for table "content_tender".
 *
 * @property int $tender_id
 * @property string|null $tender_date
 * @property string|null $tender_category
 * @property string|null $tender_status
 * @property int|null $tender_sorting
 * @property string|null $tender_image
 * @property string|null $tender_file
 * @property string|null $created_at
 * @property int|null $created_by
 * @property string|null $updated_at
 * @property int|null $updated_by
 */
class ContentTender extends \yii\db\ActiveRecord {

    public $tender_title;
    public $tender_content;
    public $tender_language;

    /**
     * {@inheritdoc}
     */
    public static function tableName() {
        return 'content_tender';
    }

    /**
     * {@inheritdoc}
     */
    public function rules() {
        return [
            [['tender_title', 'tender_content', 'tender_language','tender_category'], 'required'],
            [['tender_date_start', 'tender_date_end', 'created_at', 'updated_at', 'tender_subcategory', 'tender_tag'], 'safe'],
            [['tender_sorting', 'created_by', 'updated_by'], 'integer'],
            [['tender_category', 'tender_status', 'tender_file', 'tender_image'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels() {
        return [
            'tender_id' => Yii::t('app', 'Tender ID'),
            'tender_date_start' => Yii::t('app', 'Start Date'),
            'tender_date_end' => Yii::t('app', 'End Date'),
            'tender_category' => Yii::t('app', 'Category'),
            'tender_status' => Yii::t('app', 'Status'),
            'tender_sorting' => Yii::t('app', 'Sorting'),
            'tender_image' => Yii::t('app', 'Thumbnail'),
            'tender_file' => Yii::t('app', 'File PDF'),
            'created_at' => Yii::t('app', 'Created At'),
            'created_by' => Yii::t('app', 'Created By'),
            'updated_at' => Yii::t('app', 'Updated At'),
            'updated_by' => Yii::t('app', 'Updated By'),
            'tender_title' => Yii::t('app', 'Title'),
            'tender_content' => Yii::t('app', 'Content'),
            'tender_language' => Yii::t('app', 'Language'),
        ];
    }

}
