<?php

namespace backend\modules\contentTender\controllers;

use Yii;
use backend\modules\contentTender\models\ContentTender;
use backend\modules\contentTender\models\ContentTenderTranslation;
use backend\modules\contentTender\models\ContentTenderSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\web\UploadedFile;
use yii\helpers\ArrayHelper;
use yii\helpers\Html;

/**
 * ContentTenderController implements the CRUD actions for ContentTender model.
 */
class ContentTenderController extends Controller {

    /**
     * {@inheritdoc}
     */
    public function behaviors() {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all ContentTender models.
     * @return mixed
     */
    public function actionIndex() {
        $searchModel = new ContentTenderSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
                    'searchModel' => $searchModel,
                    'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single ContentTender model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id) {
        return $this->render('view', [
                    'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new ContentTender model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate() {
        $model = new ContentTender();
        $model->created_at = date("Y-m-d H:i:s");
        $model->created_by = Yii::$app->user->identity->id;
        $model->updated_at = date("Y-m-d H:i:s");
        $model->updated_by = Yii::$app->user->identity->id;
        $model->tender_language = 'Malay';
        if ($model->load(Yii::$app->request->post())) {
            $model->tender_image = UploadedFile::getInstance($model, 'tender_image');
            if (!empty($model->tender_image)) {
                $tender_image = 'images/modules/contentTender_' . date("YmdHis") . '.' . $model->tender_image->extension;
                if ($model->tender_image->saveAs($tender_image))
                    $model->tender_image = $tender_image;
            }
            $model->tender_file = UploadedFile::getInstance($model, 'tender_file');
            if (!empty($model->tender_file)) {
                $tender_file = 'files/modules/contentTender_' . date("YmdHis") . '.' . $model->tender_file->extension;
                if ($model->tender_file->saveAs($tender_file))
                    $model->tender_file = $tender_file;
            }
            if ($model->save()) {

                $modeltranslation = new ContentTenderTranslation();
                $modeltranslation->tender_translation_parent_id = $model->tender_id;
                $modeltranslation->tender_translation_title = $model->tender_title;
                $modeltranslation->tender_translation_content = $model->tender_content;
                $modeltranslation->tender_translation_language = $model->tender_language;
                $modeltranslation->tender_translation_main = 1;
                $modeltranslation->created_at = date("Y-m-d H:i:s");
                $modeltranslation->created_by = Yii::$app->user->identity->id;
                $modeltranslation->updated_at = date("Y-m-d H:i:s");
                $modeltranslation->updated_by = Yii::$app->user->identity->id;
                $modeltranslation->save();

                return $this->redirect(['index']);
            }
        }
        return $this->render('create', [
                    'model' => $model,
        ]);
    }

    /**
     * Updates an existing ContentTender model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id) {
        $model = $this->findModel($id);
        $model->updated_at = date("Y-m-d H:i:s");
        $model->updated_by = Yii::$app->user->identity->id;
        $original_thumbnail = $model->tender_image;

        $translation_id = '';

        if (($modeltranslation = ContentTenderTranslation::findOne(['tender_translation_parent_id' => $model->tender_id, 'tender_translation_main' => 1])) !== null) {
            $translation_id = $modeltranslation->tender_translation_id;
            $model->tender_title = $modeltranslation->tender_translation_title;
            $model->tender_content = $modeltranslation->tender_translation_content;
            $model->tender_language = $modeltranslation->tender_translation_language;
        }

        if ($model->load(Yii::$app->request->post())) {
            $model->tender_image = UploadedFile::getInstance($model, 'tender_image');
            if (!empty($model->tender_image)) {
                $tender_image = 'images/modules/contentTender_' . date("YmdHis") . '.' . $model->tender_image->extension;
                if ($model->tender_image->saveAs($tender_image))
                    $model->tender_image = $tender_image;
            } else
                $model->tender_image = $original_thumbnail;

            $model->tender_language = $modeltranslation->tender_translation_language;

            $model->tender_file = UploadedFile::getInstance($model, 'tender_file');
            if (!empty($model->tender_file)) {
                $tender_file = 'files/modules/contentTender_' . date("YmdHis") . '.' . $model->tender_file->extension;
                if ($model->tender_file->saveAs($tender_file))
                    $model->tender_file = $tender_file;
            } else
                $model->tender_image = $original_thumbnail;

            if ($model->save()) {
                if (($modeltranslation = ContentTenderTranslation::findOne($translation_id)) !== null) {
                    $modeltranslation->tender_translation_title = $model->tender_title;
                    $modeltranslation->tender_translation_content = $model->tender_content;
                    $modeltranslation->tender_translation_language = $model->tender_language;
                    $modeltranslation->updated_at = date("Y-m-d H:i:s");
                    $modeltranslation->updated_by = Yii::$app->user->identity->id;
                    $modeltranslation->save();
                }

                //insert new translation
                if (isset($_POST['newtranslation']) && !empty($_POST['newtranslation'])) {
                    foreach ($_POST['newtranslation'] as $newno) {
                        $modeltranslationnew = new ContentTenderTranslation();
                        $modeltranslationnew->tender_translation_parent_id = $model->tender_id;
                        $modeltranslationnew->tender_translation_title = $_POST['new_title_' . $newno];
                        $modeltranslationnew->tender_translation_content = $_POST['new_content_' . $newno];
                        $modeltranslationnew->tender_translation_language = $_POST['new_language_' . $newno];
                        $modeltranslationnew->tender_translation_main = 0;
                        $modeltranslationnew->created_at = date("Y-m-d H:i:s");
                        $modeltranslationnew->created_by = Yii::$app->user->identity->id;
                        $modeltranslationnew->updated_at = date("Y-m-d H:i:s");
                        $modeltranslationnew->updated_by = Yii::$app->user->identity->id;
                        $modeltranslationnew->save();
                    }
                }

                //update translation
                if (isset($_POST['oldtranslation']) && !empty($_POST['oldtranslation'])) {
                    foreach ($_POST['oldtranslation'] as $oldtranslation) {
                        if (($modeltranslationupdate = ContentTenderTranslation::findOne($oldtranslation)) !== null) {
                            $modeltranslationupdate->tender_translation_title = $_POST['old_title_' . $oldtranslation];
                            $modeltranslationupdate->tender_translation_content = $_POST['old_content_' . $oldtranslation];
                            $modeltranslationupdate->tender_translation_language = $_POST['old_language_' . $oldtranslation];
                            $modeltranslationupdate->updated_at = date("Y-m-d H:i:s");
                            $modeltranslationupdate->updated_by = Yii::$app->user->identity->id;
                            $modeltranslationupdate->save();
                        }
                    }
                }

                return $this->redirect(['index']);
            }
        }
        return $this->render('update', ['model' => $model,]);
    }

    /**
     * Deletes an existing ContentTender model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id) {
        ContentTenderTranslation::deleteAll(['tender_translation_parent_id' => $id]);
        $this->findModel($id)->delete();
        return $this->redirect(['index']);
    }

    /**
     * Finds the ContentTender model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return ContentTender the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id) {
        if (($model = ContentTender::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
    }

    public function actionGetsubcategory($parent_code = '') {
        $output = '';
        $arr = ArrayHelper::map(
                        (new \yii\db\Query())->select(['code', 'descr'])
                                ->from('ref')
                                ->where(['=', 'cat', 'TENDERSUBCATEGORY'])
                                ->andwhere(['=', 'param1', $parent_code])
                                ->orderBy(['sort' => SORT_ASC])
                                ->all(), 'code', 'descr');
        if (!empty($arr)) {
            foreach ($arr as $code => $label) {
                $output .= '<option value="' . $code . '">' . $label . '</option>';
            }
        }
        return $output;
    }

    public function actionAddtranslation($no = '') {
        $output = '<div class="ibox float-e-margins" id="new-translation-' . $no . '">
            <input type="hidden" name="newtranslation[]" value="' . $no . '">
            <div class="ibox-title">
                <button type="button" class="btn btn-primary btn-sm" onclick="deletenewtranslation(' . $no . ')">Delete</button>&nbsp;&nbsp;&nbsp;
                New Tender Translation
            </div>
            <div class="ibox-content">
                <div class="row">
                    <div class="col-sm-4">
                        <div class="form-group">
                            <label>Language</label>
                            ' . Html::dropDownList('new_language_' . $no, NULL, ArrayHelper::map(
                                (new \yii\db\Query())->select(['code', 'descr'])
                                        ->from('ref')
                                        ->where(['=', 'cat', 'TENDERLANGUAGE'])
                                        ->orderBy(['sort' => SORT_ASC])
                                        ->all(), 'code', 'descr'), [
                    'class' => 'form-control',]) . '
                        </div>
                    </div>
                    <div class="col-sm-8"><div class="form-group"><label>Title</label><input type="text" class="form-control" name="new_title_' . $no . '"></div></div>
                </div>
                <div class="form-group">
                    <label>Content</label>
                    <textarea class="summernote" name="new_content_' . $no . '"></textarea>
                </div>
            </div>
        </div>';
        return $output;
    }

    public function actionDeletetranslation($id) {
        if (($model = ContentTenderTranslation::findOne($id)) !== null) {
            $model->delete();
        }
    }

}
