<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use yii\helpers\ArrayHelper;

/* @var $this yii\web\View */
/* @var $model backend\modules\contentStaff\models\ContentStaff */

$this->title = $model->staff_id;
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Content Staffs'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="content-staff-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a(Yii::t('app', 'Update'), ['update', 'id' => $model->staff_id], ['class' => 'btn btn-primary']) ?>
        <?= Html::a(Yii::t('app', 'Delete'), ['delete', 'id' => $model->staff_id], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => Yii::t('app', 'Are you sure you want to delete this item?'),
                'method' => 'post',
            ],
        ]) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'staff_id',
            'staff_name',
            'staff_email',
            'staff_phone',
            'staff_fax',
            [
                'value' => function ($model) {
                    $ref = (new \yii\db\Query())->select(['descr'])
                            ->from('ref')
                            ->where(['=', 'cat', 'STAFFSECTOR'])
                            ->andwhere(['=', 'code', $model->staff_sector])
                            ->one();
                    if (!empty($ref))
                        return $ref['descr'];
                }
            ],
            [
                'value' => function ($model) {
                    $ref = (new \yii\db\Query())->select(['descr'])
                            ->from('ref')
                            ->where(['=', 'cat', 'STAFFDEPARTMENT'])
                            ->andwhere(['=', 'code', $model->staff_department])
                            ->one();
                    if (!empty($ref))
                        return $ref['descr'];
                }
            ],
            [
                'value' => function ($model) {
                    $ref = (new \yii\db\Query())->select(['descr'])
                            ->from('ref')
                            ->where(['=', 'cat', 'STAFFSTATUS'])
                            ->andwhere(['=', 'code', $model->staff_status])
                            ->one();
                    if (!empty($ref))
                        return $ref['descr'];
                }
            ],
            'created_at',
            'updated_at',
        ],
    ]) ?>

</div>
