<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\helpers\ArrayHelper;

/* @var $this yii\web\View */
/* @var $searchModel backend\modules\contentStaff\models\ContentStaffSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = Yii::t('app', 'Staff');
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="wrapper wrapper-content">
    <p>
        <?= Html::a(Yii::t('app', 'Create Staff'), ['create'], ['class' => 'btn btn-primary']) ?>
    </p>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>
    <div class="ibox animated fadeInRight">
        <div class="mail-box b-r-md">
            <?=
            GridView::widget([
                'dataProvider' => $dataProvider,
                'filterModel' => $searchModel,
                'tableOptions' => ['class' => 'table',],
                'summary' => '',
                'columns' => [
                    ['class' => 'yii\grid\SerialColumn'],
                    [
                        'attribute' => 'staff_image',
                        'value' => function ($model) {
                            if(!empty($model->staff_image))
                                return '<img width="150px" src="'.Yii::getAlias('@web') .'/'.$model->staff_image. '"/>';
                            else
                                return '<img width="150px" src="'.Yii::getAlias('@web') .'/images/noimage.jpg" />';
                        },
                        'format' => 'raw',
                    ],
					[
                        'attribute' => 'staff_name',
                        'value' => function ($model) {
                            return $model->staff_name;
                        }
                    ],
                    [
                        'attribute' => 'staff_sector',
                        'headerOptions' => ['style' => 'width:10%'],
                        'filter' => ArrayHelper::map(
                                (new \yii\db\Query())->select(['code', 'descr_en'])
                                        ->from('ref')
                                        ->where(['=', 'cat', 'STAFFSECTOR'])
                                        ->orderBy(['sort' => SORT_ASC])
                                        ->all(), 'code', 'descr_en'),
                        'value' => function ($model) {
                            $ref = (new \yii\db\Query())->select(['descr_en'])
                                    ->from('ref')
                                    ->where(['=', 'cat', 'STAFFSECTOR'])
                                    ->andwhere(['=', 'code', $model->staff_sector])
                                    ->one();
                            if (!empty($ref))
                                return $ref['descr_en'];
                        }
                    ],
                    [
                        'attribute' => 'staff_department',
                        'headerOptions' => ['style' => 'width:10%'],
                        'filter' => ArrayHelper::map(
                                (new \yii\db\Query())->select(['code', 'descr_en'])
                                        ->from('ref')
                                        ->where(['=', 'cat', 'STAFFDEPARTMENT'])
                                        ->orderBy(['sort' => SORT_ASC])
                                        ->all(), 'code', 'descr_en'),
                        'value' => function ($model) {
                            $ref = (new \yii\db\Query())->select(['descr_en'])
                                    ->from('ref')
                                    ->where(['=', 'cat', 'STAFFDEPARTMENT'])
                                    ->andwhere(['=', 'code', $model->staff_department])
                                    ->one();
                            if (!empty($ref))
                                return $ref['descr_en'];
                        }
                    ],
					[
                        'attribute' => 'staff_status',
                        'headerOptions' => ['style' => 'width:10%'],
                        'filter' => ArrayHelper::map(
                                (new \yii\db\Query())->select(['code', 'descr'])
                                        ->from('ref')
                                        ->where(['=', 'cat', 'STAFFSTATUS'])
                                        ->orderBy(['sort' => SORT_ASC])
                                        ->all(), 'code', 'descr'),
                        'value' => function ($model) {
                            $ref = (new \yii\db\Query())->select(['descr'])
                                    ->from('ref')
                                    ->where(['=', 'cat', 'STAFFSTATUS'])
                                    ->andwhere(['=', 'code', $model->staff_status])
                                    ->one();
                            if (!empty($ref))
                                return $ref['descr'];
                        }
                    ],
                    [
                        'class' => 'yii\grid\ActionColumn',
                        'header' => 'Action',
                        'template' => '{update} {delete}',
                        'headerOptions' => ['style' => 'text-align:center;width:10%'],
                        'contentOptions' => ['style' => 'text-align:center;'],
                    ],
                ],
            ]);
            ?>
        </div>
    </div>
</div>
