<?php

use mihaildev\ckeditor\CKEditor;
use mihaildev\elfinder\ElFinder;
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use kartik\file\FileInput;

/* @var $this yii\web\View */
/* @var $model backend\modules\contentStaff\models\ContentStaff*/
/* @var $form yii\widgets\ActiveForm */


?>
<?php $form = ActiveForm::begin(); ?>
<div class="wrapper wrapper-content animated fadeInRight" style="padding: 20px 10px 20px;">
    <div class="ibox float-e-margins">
        <div class="ibox-content">
            <div class="row">
                <div class="col-sm-6"><?= $form->field($model, 'staff_name')->textInput() ?></div>
                <div class="col-sm-6"><?= $form->field($model, 'staff_email')->textInput() ?></div>
            </div>
            <div class="row">
                <div class="col-sm-6"><?= $form->field($model, 'staff_phone')->textInput() ?></div>
                <div class="col-sm-6"><?= $form->field($model, 'staff_fax')->textInput() ?></div>
            </div>
            <div class="row">
                <div class="col-sm-6"><?= $form->field($model, 'staff_position')->textInput() ?></div>
                <div class="col-sm-6"><?= $form->field($model, 'staff_grade')->textInput() ?></div>
            </div>
            <div class="row">
                <div class="col-sm-4">
                    <?=
                    $form->field($model, 'staff_sector')->dropdownList(
                            ArrayHelper::map(
                                    (new \yii\db\Query())->select(['code', 'descr_en'])
                                            ->from('ref')
                                            ->where(['=', 'cat', 'STAFFSECTOR'])
                                            ->orderBy(['sort' => SORT_ASC])
                                            ->all(), 'code', 'descr_en'), [
                        'maxlength' => true,'onchange' => 'changesector(this.value)', 'prompt' => '-- Please choose --'])
                    ?>
                </div>
                <div class="col-sm-4">
                    <?=
                    $form->field($model, 'staff_department')->dropdownList(
                            ArrayHelper::map(
                                    (new \yii\db\Query())->select(['code', 'descr_en'])
                                            ->from('ref')
                                            ->where(['=', 'cat', 'STAFFDEPARTMENT'])
                                            ->orderBy(['sort' => SORT_ASC])
                                            ->all(), 'code', 'descr_en'), [
                        'maxlength' => true,'prompt' => '-- Please choose --'])
                    ?>
                </div>
                <div class="col-sm-4">
                    <?=
                    $form->field($model, 'staff_status')->dropdownList(
                            ArrayHelper::map(
                                    (new \yii\db\Query())->select(['code', 'descr'])
                                            ->from('ref')
                                            ->where(['=', 'cat', 'STAFFSTATUS'])
                                            ->orderBy(['sort' => SORT_ASC])
                                            ->all(), 'code', 'descr'), [
                        'maxlength' => true,])
                    ?>
                </div>      
            </div>
            <div class="row">
                    <div class="col-sm-12">
                    <?php
                    $img_url = Yii::getAlias('@web') . '/images/noimage.jpg';
                    if (!empty($model->staff_image)) {
                        echo $form->field($model, 'staff_image')->widget(FileInput::classname(), [
                            'options' => ['accept' => 'image/*'],
                            'pluginOptions' => [
                                'showUpload' => false,
                                'initialPreview' => [
                                    '<img style="width:100%" src="' . Yii::getAlias('@web') . '/' . $model->staff_image . '"/>',
                                ],
                            ]
                        ]);
                    } else {
                        echo $form->field($model, 'staff_image')->widget(FileInput::classname(), [
                            'options' => ['accept' => 'image/*'],
                        ]);
                    }
                    ?>
                </div>
            </div>
        </div>
    </div>

    <div class="form-group">
        <?= Html::submitButton($model->isNewRecord ? 'Create' : 'Update', ['class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary']) ?>
    </div>
</div>
<?php ActiveForm::end(); ?>
<script>
    function changesector(parent_code) {
        $.ajax({
            url: "getsector?parent_code=" + parent_code,
            method: "GET",
            success: function (response) {
                $('#contentstaff-staff_department').find('option').not(':first').remove();
                $('#contentstaff-staff_department').append(response);
            },
        });
    }
</script>
