<?php

namespace backend\modules\contentStaff\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\modules\contentStaff\models\ContentStaff;

/**
 * ContentStaffSearch represents the model behind the search form of `backend\modules\contentStaff\models\ContentStaff`.
 */
class ContentStaffSearch extends ContentStaff {

    public $slider_title;

    /**
     * {@inheritdoc}
     */
    public function rules() {
        return [
            [[], 'safe'],
            [['staff_id','staff_sorting','created_by', 'updated_by'], 'integer'],
            [['staff_name','staff_email','staff_phone', 'staff_fax', 'staff_grade', 'staff_sector','staff_department','staff_image','staff_status','created_at', 'updated_at'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios() {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params) {
        $query = ContentStaff::find();

        // add conditions that should always apply here
        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere(['=', 'staff_sector', $this->staff_sector]);
        $query->andFilterWhere(['=', 'staff_department', $this->staff_department]);
        $query->andFilterWhere(['LIKE', 'staff_name', $this->staff_name]);


        return $dataProvider;
    }

}
