<?php

namespace backend\modules\contentStaff\models;

use Yii;

/**
 * This is the model class for table "content_staff".
 *
 * @property int $staff_id
 * @property string|null $staff_name
 * @property string|null $staff_email
 * @property string|null $staff_phone
 * @property string|null $staff_fax
 * @property string|null $staff_position
 * @property string|null $staff_grade
 * @property string|null $staff_sector
 * @property string|null $staff_department
 * @property string|null $staff_image
 * @property int|null $staff_sorting
 * @property string|null $staff_status
 * @property string|null $created_at
 * @property int|null $created_by
 * @property string|null $updated_at
 * @property int|null $updated_by
 */
class ContentStaff extends \yii\db\ActiveRecord {

    /**
     * {@inheritdoc}
     */
    public static function tableName() {
        return 'content_staff';
    }

    /**
     * {@inheritdoc}
     */
    public function rules() {
        return [
            [['staff_name','staff_sector', 'staff_department'], 'required'],
            [['created_at', 'updated_at'], 'safe'],
            [['staff_sorting','created_by', 'updated_by'], 'integer'],
            [['staff_email','staff_phone', 'staff_fax', 'staff_grade', 'staff_sector','staff_department','staff_image','staff_status'], 'string', 'max' => 255],
            [['staff_name'], 'string', 'max' => 500],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels() {
        return [
            'staff_id' => Yii::t('app', 'Staff ID'),
            'staff_name' => Yii::t('app', 'Name'),
            'staff_email' => Yii::t('app', 'Email'),
            'staff_phone' => Yii::t('app', 'Phone'),
            'staff_fax' => Yii::t('app', 'Fax'),
            'staff_position' => Yii::t('app', 'Position'),
            'staff_grade' => Yii::t('app', 'Grade'),
            'staff_sector' => Yii::t('app', 'Sector'),
            'staff_department' => Yii::t('app', 'Department'),
            'staff_image' => Yii::t('app', 'Image'),
            'staff_sorting' => Yii::t('app', 'Sorting'),	
            'staff_status' => Yii::t('app', 'Status'),
            'created_at' => Yii::t('app', 'Created At'),
            'created_by' => Yii::t('app', 'Created By'),
            'updated_at' => Yii::t('app', 'Updated At'),
            'updated_by' => Yii::t('app', 'Updated By'),
        ];
    }

}
