<?php

namespace backend\modules\contentStaff\controllers;

use Yii;
use backend\modules\contentStaff\models\ContentStaff;
use backend\modules\contentStaff\models\ContentStaffSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\web\UploadedFile;
use yii\helpers\ArrayHelper;
use yii\helpers\Html;

/**
 * ContentStaffController implements the CRUD actions for ContentStaff model.
 */
class ContentStaffController extends Controller {

    /**
     * {@inheritdoc}
     */
    public function behaviors() {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all ContentStaff models.
     * @return mixed
     */
    public function actionIndex() {
        $searchModel = new ContentStaffSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
                    'searchModel' => $searchModel,
                    'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single ContentStaff model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id) {
        return $this->render('view', [
                    'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new ContentStaff model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate() {
        $model = new ContentStaff();
        $model->created_at = date("Y-m-d H:i:s");
        $model->created_by = Yii::$app->user->identity->id;
        $model->updated_at = date("Y-m-d H:i:s");
        $model->updated_by = Yii::$app->user->identity->id;

        if ($model->load(Yii::$app->request->post())) {

            //upload file image 
            $model->staff_image = UploadedFile::getInstance($model, 'staff_image');

            if (!empty($model->staff_image)) {
                $staff_image = 'images/modules/contentStaff_'. date("YmdHis") . '.' . $model->staff_image->extension;
                if ($model->staff_image->saveAs($staff_image))
                    $model->staff_image = $staff_image;
            }

            // file is uploaded successfully
             if ($model->save(false)) {
                 return $this->redirect(['index']);
            }
        }
        return $this->render('create', [
                    'model' => $model,
        ]);
    }

    /**
     * Updates an existing ContentStaff model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id) {
        $model = $this->findModel($id);
        $model->updated_at = date("Y-m-d H:i:s");
        $model->updated_by = Yii::$app->user->identity->id;

        $staff_image = $model->staff_image;

        if ($model->load(Yii::$app->request->post())) {

            $model->staff_image = UploadedFile::getInstance($model, 'staff_image');

            if (!empty($model->staff_image)) {
                $staff_image = 'images/modules/contentStaff_' . date("YmdHis") . '.' . $model->staff_image->extension;
                if ($model->staff_image->saveAs($staff_image))
                    $model->staff_image = $staff_image;
            } else
                $model->staff_image = $staff_image;

            // file is uploaded successfully
             if ($model->save(false)) {
                 return $this->redirect(['index']);
            }
        }
        return $this->render('update', ['model' => $model,]);
    }

    /**
     * Deletes an existing ContentStaff model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id) {
        $model = $this->findModel($id);
        $model->delete();
        return $this->redirect(['index']);
    }

    /**
     * Finds the ContentStaff model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return ContentStaff the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id) {
        if (($model = ContentStaff::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
    }
    
    public function actionGetsector($parent_code = '') {
        $output = '';
        $arr = ArrayHelper::map(
                        (new \yii\db\Query())->select(['code', 'descr_en'])
                                ->from('ref')
                                ->where(['=', 'cat', 'STAFFDEPARTMENT'])
                                ->andwhere(['=', 'param1', $parent_code])
                                ->orderBy(['sort' => SORT_ASC])
                                ->all(), 'code', 'descr_en');
        if (!empty($arr)) {
            foreach ($arr as $code => $label) {
                $output .= '<option value="' . $code . '">' . $label . '</option>';
            }
        }
        return $output;
    }
}
