<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model backend\modules\contentAnnouncement\models\ContentAnnouncement */

$this->title = Yii::t('app', 'View Details Slider Image');
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Slider Images'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
$this->registerCss('.detail-view th{width:20%;text-align:right;white-space: nowrap;}');
\yii\web\YiiAsset::register($this);
?>
<div class="wrapper wrapper-content animated fadeInRight">
    <?= Html::a(Yii::t('app', 'Back to list'), ['index'], ['class' => 'btn btn-primary']) ?><br><br>
    <div class="ibox float-e-margins">
        <div class="ibox-content">
            <?php
            echo DetailView::widget([
                'model' => $model,
                'attributes' => [
                    [
                        'attribute' => 'slider_type',
                        'value' => \backend\modules\refdynawebv2\models\Ref::getDesc('SLIDERTYPE', $model->slider_type),
                    ],
                    [
                        'attribute' => 'slider_portal',
                        'value' => \backend\modules\refdynawebv2\models\Ref::getDesc('PORTALPAGE', $model->slider_portal),
                    ],
                    [
                        'attribute' => 'slider_status',
                        'value' => \backend\modules\refdynawebv2\models\Ref::getDesc('CONTENT_STATUS', $model->slider_status),
                    ],
                    'slider_sort',
                    'slider_url',
                    [
                        'attribute' => 'slider_dimension',
                        'value' => \backend\modules\refdynawebv2\models\Ref::getDesc('SLIDERDIMENSION', $model->slider_dimension),
                    ],
                    [
                        'attribute' => 'slider_transition',
                        'value' => function ($model) {
                            return \backend\modules\refdynawebv2\models\Ref::getDesc2('SLIDERTRANSITION', $model->slider_transition, $model->slider_dimension);
                        }
                    ],
                ],
            ]);

            $modelTranslation = \backend\modules\contentSlider\models\ContentSliderTranslation::find()
                    ->where(['=', 'slider_translation_parent_id', $model->slider_id])
                    ->orderBy(['slider_translation_id' => SORT_ASC])
                    ->all();
            if (!empty($modelTranslation)) {
                foreach ($modelTranslation as $rowTranslation) {
                    $slider_img = '';
                    if (!empty($rowTranslation->slider_translation_img))
                        $slider_img = '<img src="' . Yii::getAlias('@web') . '/' . $rowTranslation->slider_translation_img . '" height="100">';
                    echo '<table class="table table-striped table-bordered detail-view">
                        <tbody>
                            <tr>
                                <th>Language</th>
                                <td>' . \backend\modules\refdynawebv2\models\Ref::getDesc('CONTENT_LANGUAGE', $rowTranslation->slider_translation_language) . '</td>
                            </tr>
                            <tr>
                                <th>Title</th>
                                <td>' . $rowTranslation->slider_translation_title . '</td>
                            </tr>
                            <tr>
                                <th>Image</th>
                                <td>' . $slider_img . '</td>
                            </tr>
                        </tbody>
                    </table>';
                }
            }
            ?>
        </div>
    </div>
</div>