<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\helpers\ArrayHelper;
use backend\modules\contentSlider\models\ContentSliderTranslation;

$this->title = Yii::t('app', 'Slider Images');
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="wrapper wrapper-content">
    <p><?= Html::a(Yii::t('app', 'Create Slider Image'), ['create'], ['class' => 'btn btn-primary']) ?></p>
    <div class="ibox animated fadeInRight">
        <div class="mail-box b-r-md">
            <?=
            GridView::widget([
                'dataProvider' => $dataProvider,
                'filterModel' => $searchModel,
                'tableOptions' => ['class' => 'table',],
                'summary' => '',
                'columns' => [
                    ['class' => 'yii\grid\SerialColumn'],
                    [
                        'attribute' => 'slider_title',
                        'value' => function ($model) {
                            if (($modeltranslation = ContentSliderTranslation::findOne(['slider_translation_parent_id' => $model->slider_id, 'slider_translation_main' => 1])) !== null) {
                                return $modeltranslation->slider_translation_title;
                            }
                        }
                    ],
                    [
                        'attribute' => 'slider_type',
                        'filter' => ArrayHelper::map(
                                (new \yii\db\Query())->select(['code', 'descr'])
                                        ->from('ref')
                                        ->where(['=', 'cat', 'SLIDERTYPE'])
                                        ->orderBy(['sort' => SORT_ASC])
                                        ->all(), 'code', 'descr'),
                        'value' => function ($model) {
                            $ref = (new \yii\db\Query())->select(['descr'])
                                    ->from('ref')
                                    ->where(['=', 'cat', 'SLIDERTYPE'])
                                    ->andwhere(['=', 'code', $model->slider_type])
                                    ->one();
                            if (!empty($ref))
                                return $ref['descr'];
                        }
                    ],
                    [
                        'attribute' => 'slider_portal',
                        'filter' => ArrayHelper::map(
                                (new \yii\db\Query())->select(['code', 'descr'])
                                        ->from('ref')
                                        ->where(['=', 'cat', 'PORTALPAGE'])
                                        ->orderBy(['sort' => SORT_ASC])
                                        ->all(), 'code', 'descr'),
                        'value' => function ($model) {
                            $ref = (new \yii\db\Query())->select(['descr'])
                                    ->from('ref')
                                    ->where(['=', 'cat', 'PORTALPAGE'])
                                    ->andwhere(['=', 'code', $model->slider_portal])
                                    ->one();
                            if (!empty($ref))
                                return $ref['descr'];
                        }
                    ],
                    [
                        'attribute' => 'slider_status',
                        'filter' => ArrayHelper::map(
                                (new \yii\db\Query())->select(['code', 'descr'])
                                        ->from('ref')
                                        ->where(['=', 'cat', 'CONTENT_STATUS'])
                                        ->orderBy(['sort' => SORT_ASC])
                                        ->all(), 'code', 'descr'),
                        'value' => function ($model) {
                            $ref = (new \yii\db\Query())->select(['descr'])
                                    ->from('ref')
                                    ->where(['=', 'cat', 'CONTENT_STATUS'])
                                    ->andwhere(['=', 'code', $model->slider_status])
                                    ->one();
                            if (!empty($ref))
                                return $ref['descr'];
                        }
                    ],
                    'slider_sort',
                    'slider_url',
                    [
                        'header' => 'Language',
                        'format' => 'raw',
                        'value' => function ($model) {
                            $output = '';
                            $arr = ArrayHelper::map(
                                            (new \yii\db\Query())->select(['*'])
                                                    ->from('content_slider_translation')
                                                    ->orderBy(['slider_translation_language' => SORT_ASC])
                                                    ->groupby(['slider_translation_language'])
                                                    ->all(), 'slider_translation_language', 'slider_translation_language');
                            if (!empty($arr)) {
                                foreach ($arr as $code) {
                                    $ref = (new \yii\db\Query())->select(['descr'])
                                            ->from('ref')
                                            ->where(['=', 'cat', 'CONTENT_LANGUAGE'])
                                            ->andwhere(['=', 'code', $code])
                                            ->one();
                                    if (!empty($ref)) {
                                        $label_class = 'label-dark';
                                        if (($modeltranslation = ContentSliderTranslation::findOne(['slider_translation_parent_id' => $model->slider_id, 'slider_translation_language' => $code])) !== null) {
                                            $label_class = 'label-primary';
                                        }
                                        $output .= '<span class="label ' . $label_class . '">' . $ref['descr'] . '</span>&nbsp;&nbsp;';
                                    }
                                }
                            }
                            return $output . Html::a('<i class="fa fa-plus" aria-hidden="true"></i>', ['addtranslation', 'id' => $model->slider_id], ['class' => 'label label-danger']);
                        }
                    ],
                    [
                        'class' => 'yii\grid\ActionColumn',
                        'header' => 'Action',
                        'template' => '{view} {update} {delete}',
                        'headerOptions' => ['style' => 'text-align:center;width:10%'],
                        'contentOptions' => ['style' => 'text-align:center;'],
                    ],
                ],
            ]);
            ?>
        </div>
    </div>
</div>
