<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use kartik\file\FileInput;
use backend\modules\contentSlider\models\ContentSliderTranslation;

/* @var $this yii\web\View */
/* @var $model backend\modules\contentSlider\models\ContentSlider */
/* @var $form yii\widgets\ActiveForm */
?>
<?php $form = ActiveForm::begin(); ?>
<div class="wrapper wrapper-content animated fadeInRight" style="padding: 20px 10px 20px;">
    <div class="ibox float-e-margins">
        <div class="ibox-content">
            <div class="row">
                <div class="col-sm-3">
                    <?=
                    $form->field($model, 'slider_type')->dropdownList(
                            ArrayHelper::map(
                                    (new \yii\db\Query())->select(['code', 'descr'])
                                            ->from('ref')
                                            ->where(['=', 'cat', 'SLIDERTYPE'])
                                            ->orderBy(['sort' => SORT_ASC])
                                            ->all(), 'code', 'descr'), [
                        'maxlength' => true, 'prompt' => '-- Please choose --'])
                    ?>
                </div>
                <div class="col-sm-3">
                    <?=
                    $form->field($model, 'slider_portal')->dropdownList(
                            ArrayHelper::map(
                                    (new \yii\db\Query())->select(['code', 'descr'])
                                            ->from('ref')
                                            ->where(['=', 'cat', 'PORTALPAGE'])
                                            ->orderBy(['sort' => SORT_ASC])
                                            ->all(), 'code', 'descr'), [
                        'maxlength' => true, 'prompt' => '-- Please choose --'])
                    ?>
                </div>
                <div class="col-sm-3">
                    <?=
                    $form->field($model, 'slider_status')->dropdownList(
                            ArrayHelper::map(
                                    (new \yii\db\Query())->select(['code', 'descr'])
                                            ->from('ref')
                                            ->where(['=', 'cat', 'CONTENT_STATUS'])
                                            ->orderBy(['sort' => SORT_ASC])
                                            ->all(), 'code', 'descr'), [
                        'maxlength' => true, 'prompt' => '-- Please choose --'])
                    ?>
                </div>

                <div class="col-sm-3"><?= $form->field($model, 'slider_sort')->textInput() ?></div>
            </div>
            <div class="row">
                <div class="col-sm-3"><?= $form->field($model, 'slider_url')->textInput(['maxlength' => true]) ?></div>
                <div class="col-sm-3">
                    <?=
                    $form->field($model, 'slider_dimension')->dropdownList(
                            ArrayHelper::map(
                                    (new \yii\db\Query())->select(['code', 'descr'])
                                            ->from('ref')
                                            ->where(['=', 'cat', 'SLIDERDIMENSION'])
                                            ->orderBy(['sort' => SORT_ASC])
                                            ->all(), 'code', 'descr'), [
                        'maxlength' => true, 'prompt' => '-- Please choose --', 'onchange' => "changecategory(this.value)",])
                    ?>
                </div>
                <div class="col-sm-6">
                    <?=
                    $form->field($model, 'slider_transition')->dropdownList(
                            ArrayHelper::map(
                                    (new \yii\db\Query())->select(['code', 'descr'])
                                            ->from('ref')
                                            ->where(['=', 'cat', 'SLIDERTRANSITION'])
                                            ->andwhere(['=', 'param1', $model->slider_dimension])
                                            ->orderBy(['descr' => SORT_ASC])
                                            ->all(), 'code', 'descr'), [
                        'maxlength' => true, 'prompt' => '-- Please choose --'])
                    ?>
                </div>
            </div>
        </div>
    </div>

    <div class="ibox float-e-margins">
        <div class="ibox-content">
            <div class="row">
                <div class="col-sm-3">
                    <?=
                    $form->field($model, 'slider_language')->dropdownList(
                            ArrayHelper::map(
                                    (new \yii\db\Query())->select(['code', 'descr'])
                                            ->from('ref')
                                            ->where(['=', 'cat', 'CONTENT_LANGUAGE'])
                                            ->orderBy(['sort' => SORT_ASC])
                                            ->all(), 'code', 'descr'), [
                        'maxlength' => true,])
                    ?>
                </div>
                <div class="col-sm-9"><?= $form->field($model, 'slider_title')->textInput() ?></div>
            </div>
            <?php
            if (!empty($model->slider_img)) {
                echo $form->field($model, 'slider_img')->widget(FileInput::classname(), [
                    'options' => ['accept' => 'image/*'],
                    'pluginOptions' => [
                        'showUpload' => false,
                        'showCaption' => false,
                        'showRemove' => false,
                        'showUpload' => false,
                        'browseClass' => 'btn btn-warning btn-block',
                        'browseIcon' => '<i class="glyphicon glyphicon-camera"></i>&nbsp;&nbsp;',
                        'browseLabel' => 'Select Image',
                        'initialPreview' => ['<img style="max-width:100%" src="' . Yii::getAlias('@web') . '/' . $model->slider_img . '"/>'],
                    ]
                ]);
            } else {
                echo $form->field($model, 'slider_img')->widget(FileInput::classname(), [
                    'options' => ['accept' => 'image/*'],
                    'pluginOptions' => [
                        'showUpload' => false,
                        'showCaption' => false,
                        'showRemove' => false,
                        'showUpload' => false,
                        'browseClass' => 'btn btn-warning btn-block',
                        'browseIcon' => '<i class="glyphicon glyphicon-camera"></i>&nbsp;&nbsp;',
                        'browseLabel' => 'Select Image'
                    ],
                ]);
            }
            ?>
        </div> 
    </div>

    <?php
    $modeltranslation = ContentSliderTranslation::find()
                    ->where(['=', 'slider_translation_parent_id', $model->slider_id])
                    ->andwhere(['=', 'slider_translation_main', '0'])
                    ->orderBy(['slider_translation_id' => SORT_ASC])->all();
    if (!empty($modeltranslation)) {
        foreach ($modeltranslation as $rowtranslation) {
            echo '<div class="ibox float-e-margins" id="old-translation-' . $rowtranslation->slider_translation_id . '">
            <input type="hidden" name="oldtranslation[]" value="' . $rowtranslation->slider_translation_id . '">
            <div class="ibox-title">
                <button type="button" class="btn btn-primary btn-sm" onclick="deleteoldtranslation(' . $rowtranslation->slider_translation_id . ')">Delete</button>&nbsp;&nbsp;&nbsp;
                Slider Translation
            </div>
            <div class="ibox-content">
                <div class="row">
                    <div class="col-sm-3">
                        <div class="form-group">
                            <label>Language</label>
                            ' . Html::dropDownList('old_language_' . $rowtranslation->slider_translation_id, $rowtranslation->slider_translation_language, ArrayHelper::map(
                            (new \yii\db\Query())->select(['code', 'descr'])
                                    ->from('ref')
                                    ->where(['=', 'cat', 'CONTENT_LANGUAGE'])
                                    ->orderBy(['sort' => SORT_ASC])
                                    ->all(), 'code', 'descr'), [
                'class' => 'form-control',]) . '
                        </div>
                    </div>
                    <div class="col-sm-9">
                        <div class="form-group">
                            <label>Title</label>
                            <input type="text" class="form-control" name="old_title_' . $rowtranslation->slider_translation_id . '" value="' . $rowtranslation->slider_translation_title . '">
                        </div>
                    </div>
                </div>';

            if (!empty($rowtranslation->slider_translation_img)) {
                echo FileInput::widget([
                    'name' => 'old_img_' . $rowtranslation->slider_translation_id,
                    'options' => ['accept' => 'image/*'],
                    'pluginOptions' => [
                        'showUpload' => false,
                        'showCaption' => false,
                        'showRemove' => false,
                        'showUpload' => false,
                        'browseClass' => 'btn btn-warning btn-block',
                        'browseIcon' => '<i class="glyphicon glyphicon-camera"></i>&nbsp;&nbsp;',
                        'browseLabel' => 'Select Image',
                        'initialPreview' => [
                            '<img style="width:100%" src="' . Yii::getAlias('@web') . '/' . $rowtranslation->slider_translation_img . '"/>',
                        ],
                    ],
                ]);
            } else
                echo FileInput::widget([
                    'name' => 'old_img_' . $rowtranslation->slider_translation_id,
                    'options' => ['accept' => 'image/*'],
                    'pluginOptions' => [
                        'showUpload' => false,
                        'showCaption' => false,
                        'showRemove' => false,
                        'showUpload' => false,
                        'browseClass' => 'btn btn-warning btn-block',
                        'browseIcon' => '<i class="glyphicon glyphicon-camera"></i>&nbsp;&nbsp;',
                        'browseLabel' => 'Select Image',
                    ],
                ]);


            echo '
            </div>
        </div>';
        }
    }
    ?>

    <div class="form-group">
        <?= Html::a(Yii::t('app', 'Back'), ['index'], ['class' => 'btn btn-primary']) ?>
        <?= Html::submitButton(Yii::t('app', 'Save'), ['class' => 'btn btn-success']) ?>
    </div>
</div>
<?php ActiveForm::end(); ?>
<script>
    function changecategory(parent_code) {
        $.ajax({
            url: "getsubcategory?parent_code=" + parent_code,
            method: "GET",
            success: function (response) {
                $('#contentslider-slider_transition').find('option').not(':first').remove();
                $('#contentslider-slider_transition').append(response);
            },
        });
    }
    
    function deleteoldtranslation(id) {
        var r = confirm("Are you sure to delete this data?");
        if (r == true) {
            $.ajax({
                url: "deletetranslation?id=" + id,
                method: "GET",
                success: function (response) {
                    $('#old-translation-' + id).remove();
                },
            });
        }
    }

    function getreflist(code, cat) {
        $.ajax({
            url: "../../refdynawebv2/ref/getreflist?code=" + code + '&cat=' + cat,
            method: "GET",
            success: function (response) {
                $('#contentslider-slider_transition').html(response);
            }
        });
    }
</script>