<?php

namespace backend\modules\contentSlider\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\modules\contentSlider\models\ContentSliderTranslation;

/**
 * ContentSliderTranslationSearch represents the model behind the search form of `backend\modules\contentSlider\models\ContentSliderTranslation`.
 */
class ContentSliderTranslationSearch extends ContentSliderTranslation
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['slider_translation_id', 'slider_translation_parent_id', 'slider_translation_main', 'created_by', 'updated_by'], 'integer'],
            [['slider_translation_title', 'slider_translation_img', 'slider_translation_language', 'created_at', 'updated_at'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = ContentSliderTranslation::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'slider_translation_id' => $this->slider_translation_id,
            'slider_translation_parent_id' => $this->slider_translation_parent_id,
            'slider_translation_main' => $this->slider_translation_main,
            'created_at' => $this->created_at,
            'created_by' => $this->created_by,
            'updated_at' => $this->updated_at,
            'updated_by' => $this->updated_by,
        ]);

        $query->andFilterWhere(['like', 'slider_translation_title', $this->slider_translation_title])
            ->andFilterWhere(['like', 'slider_translation_img', $this->slider_translation_img])
            ->andFilterWhere(['like', 'slider_translation_language', $this->slider_translation_language]);

        return $dataProvider;
    }
}
