<?php

namespace backend\modules\contentSlider\models;

use Yii;

/**
 * This is the model class for table "content_slider_translation".
 *
 * @property int $slider_translation_id
 * @property int|null $slider_translation_parent_id
 * @property string|null $slider_translation_title
 * @property string|null $slider_translation_img
 * @property int|null $slider_translation_main
 * @property string|null $slider_translation_language
 * @property string|null $created_at
 * @property int|null $created_by
 * @property string|null $updated_at
 * @property int|null $updated_by
 */
class ContentSliderTranslation extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'content_slider_translation';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['slider_translation_parent_id', 'slider_translation_main', 'created_by', 'updated_by'], 'integer'],
            [['slider_translation_title', 'slider_translation_img'], 'string'],
            [['created_at', 'updated_at'], 'safe'],
            [['slider_translation_language'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'slider_translation_id' => Yii::t('app', 'Slider Translation ID'),
            'slider_translation_parent_id' => Yii::t('app', 'Slider Translation Parent ID'),
            'slider_translation_title' => Yii::t('app', 'Slider Translation Title'),
            'slider_translation_img' => Yii::t('app', 'Slider Translation Img'),
            'slider_translation_main' => Yii::t('app', 'Slider Translation Main'),
            'slider_translation_language' => Yii::t('app', 'Slider Translation Language'),
            'created_at' => Yii::t('app', 'Created At'),
            'created_by' => Yii::t('app', 'Created By'),
            'updated_at' => Yii::t('app', 'Updated At'),
            'updated_by' => Yii::t('app', 'Updated By'),
        ];
    }
}
