<?php

namespace backend\modules\contentSlider\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\modules\contentSlider\models\ContentSlider;
use Yii;

/**
 * ContentSliderSearch represents the model behind the search form of `backend\modules\contentSlider\models\ContentSlider`.
 */
class ContentSliderSearch extends ContentSlider {

    public $slider_title;

    /**
     * {@inheritdoc}
     */
    public function rules() {
        return [
            [['slider_id', 'slider_sort'], 'integer'],
            [['slider_title', 'slider_portal', 'slider_status', 'slider_url', 'created_at', 'created_by', 'updated_at', 'updated_by', 'slider_type'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios() {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params) {
        $query = ContentSlider::find()->innerJoin('content_slider_translation', 'content_slider_translation.slider_translation_parent_id=content_slider.slider_id')
                ->where(['=', 'content_slider_translation.slider_translation_main', '1']);

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider(['query' => $query, 'pagination' => ['pageSize' => 10,]]);
        $dataProvider->setSort(['defaultOrder' => ['updated_at' => SORT_DESC]]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions

        $query->andFilterWhere(['=', 'slider_type', $this->slider_type])
                ->andFilterWhere(['=', 'slider_portal', $this->slider_portal])
                ->andFilterWhere(['=', 'slider_status', $this->slider_status])
                ->andFilterWhere(['=', 'slider_sort', $this->slider_sort])
                ->andFilterWhere(['like', 'slider_url', $this->slider_url]);
        $query->andFilterWhere(['LIKE', 'slider_translation_title', $this->slider_title]);
        return $dataProvider;
    }

}
