<?php

namespace backend\modules\contentSlider\models;

use Yii;

/**
 * This is the model class for table "content_slider".
 *
 * @property int $slider_id
 * @property string|null $slider_portal
 * @property string|null $slider_status
 * @property int|null $slider_sort
 * @property string|null $slider_url
 * @property string|null $created_at
 * @property string|null $created_by
 * @property string|null $updated_at
 * @property string|null $updated_by
 */
class ContentSlider extends \yii\db\ActiveRecord {

    public $slider_title;
    public $slider_img;
    public $slider_language;

    /**
     * {@inheritdoc}
     */
    public static function tableName() {
        return 'content_slider';
    }

    /**
     * {@inheritdoc}
     */
    public function rules() {
        return [
            [['slider_portal', 'slider_status', 'slider_title', 'slider_language', 'slider_type'], 'required'],
            [['slider_sort'], 'integer'],
            [['slider_img', 'created_at', 'updated_at', 'slider_portal', 'slider_status', 'slider_url', 'created_by', 'updated_by', 'slider_dimension', 'slider_transition'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels() {
        return [
            'slider_id' => Yii::t('app', 'Slider ID'),
            'slider_portal' => Yii::t('app', 'Portal Display'),
            'slider_status' => Yii::t('app', 'Status'),
            'slider_sort' => Yii::t('app', 'Sorting'),
            'slider_url' => Yii::t('app', 'URL Related'),
            'created_at' => Yii::t('app', 'Created At'),
            'created_by' => Yii::t('app', 'Created By'),
            'updated_at' => Yii::t('app', 'Updated At'),
            'updated_by' => Yii::t('app', 'Updated By'),
            'slider_title' => Yii::t('app', 'Title'),
            'slider_img' => Yii::t('app', 'Image'),
            'slider_language' => Yii::t('app', 'Language'),
            'slider_type' => Yii::t('app', 'Image Type'),
            'slider_dimension' => Yii::t('app', 'Transition Dimension'),
            'slider_transition' => Yii::t('app', 'Transition Type'),
        ];
    }

}
