<?php

namespace backend\modules\contentSlider\controllers;

use Yii;
use backend\modules\contentSlider\models\ContentSlider;
use backend\modules\contentSlider\models\ContentSliderSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use backend\modules\contentSlider\models\ContentSliderTranslation;
use yii\web\UploadedFile;
use yii\helpers\ArrayHelper;

/**
 * ContentSliderController implements the CRUD actions for ContentSlider model.
 */
class ContentSliderController extends Controller {

    /**
     * {@inheritdoc}
     */
    public function behaviors() {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all ContentSlider models.
     * @return mixed
     */
    public function actionIndex() {
        $searchModel = new ContentSliderSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
                    'searchModel' => $searchModel,
                    'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single ContentSlider model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id) {
        return $this->render('view', [
                    'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new ContentSlider model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate() {
        $model = new ContentSlider();
        $model->created_at = date("Y-m-d H:i:s");
        $model->created_by = Yii::$app->user->identity->id;
        $model->updated_at = date("Y-m-d H:i:s");
        $model->updated_by = Yii::$app->user->identity->id;
        $model->slider_language = 'Malay';
        if ($model->load(Yii::$app->request->post())) {
            if ($model->save()) {

                $model->slider_img = UploadedFile::getInstance($model, 'slider_img');
                if (!empty($model->slider_img)) {
                    $slider_img = 'images/modules/contentSlider_' . date("YmdHis") . '.' . $model->slider_img->extension;
                    if ($model->slider_img->saveAs($slider_img))
                        $model->slider_img = $slider_img;
                }
                $modeltranslation = new ContentSliderTranslation();
                $modeltranslation->slider_translation_parent_id = $model->slider_id;
                $modeltranslation->slider_translation_title = $model->slider_title;
                $modeltranslation->slider_translation_img = $model->slider_img;
                $modeltranslation->slider_translation_language = $model->slider_language;
                $modeltranslation->slider_translation_main = 1;
                $modeltranslation->created_at = date("Y-m-d H:i:s");
                $modeltranslation->created_by = Yii::$app->user->identity->id;
                $modeltranslation->updated_at = date("Y-m-d H:i:s");
                $modeltranslation->updated_by = Yii::$app->user->identity->id;
                $modeltranslation->save();

                return $this->redirect(['index']);
            }
        }
        return $this->render('create', ['model' => $model,]);
    }

    /**
     * Updates an existing ContentSlider model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id) {
        $model = $this->findModel($id);
        $model->updated_at = date("Y-m-d H:i:s");
        $model->updated_by = Yii::$app->user->identity->id;

        if (($modeltranslation = ContentSliderTranslation::findOne(['slider_translation_parent_id' => $model->slider_id, 'slider_translation_main' => 1])) !== null) {
            $translation_id = $modeltranslation->slider_translation_id;
            $model->slider_title = $modeltranslation->slider_translation_title;
            $model->slider_img = $modeltranslation->slider_translation_img;
            $model->slider_language = $modeltranslation->slider_translation_language;
        }
        $count_img = 0;

        if ($model->load(Yii::$app->request->post())) {
            if ($model->save()) {

                if (($modeltranslation = ContentSliderTranslation::findOne($translation_id)) !== null) {
                    $count_img++;
                    $model->slider_img = UploadedFile::getInstance($model, 'slider_img');
                    if (!empty($model->slider_img)) {
                        $slider_img = 'images/modules/contentSlider_' . date("YmdHis") . '_' . $count_img . '.' . $model->slider_img->extension;
                        if ($model->slider_img->saveAs($slider_img))
                            $modeltranslation->slider_translation_img = $slider_img;
                    }
                    $modeltranslation->slider_translation_title = $model->slider_title;
                    $modeltranslation->slider_translation_language = $model->slider_language;
                    $modeltranslation->updated_at = date("Y-m-d H:i:s");
                    $modeltranslation->updated_by = Yii::$app->user->identity->id;
                    $modeltranslation->save();
                }

                //update translation
                if (isset($_POST['oldtranslation']) && !empty($_POST['oldtranslation'])) {
                    foreach ($_POST['oldtranslation'] as $oldtranslation) {
                        if (($modeltranslationupdate = ContentSliderTranslation::findOne($oldtranslation)) !== null) {
                            $count_img++;
                            $slider_translation_img = UploadedFile::getInstanceByName('old_img_' . $oldtranslation);
                            if (!empty($slider_translation_img)) {
                                $slider_translation_img_name = 'images/modules/contentSlider_' . date("YmdHis") . '_' . $count_img . '.' . $slider_translation_img->extension;
                                if ($slider_translation_img->saveAs($slider_translation_img_name))
                                    $modeltranslationupdate->slider_translation_img = $slider_translation_img_name;
                            }

                            $modeltranslationupdate->slider_translation_title = $_POST['old_title_' . $oldtranslation];
                            $modeltranslationupdate->slider_translation_language = $_POST['old_language_' . $oldtranslation];
                            $modeltranslationupdate->updated_at = date("Y-m-d H:i:s");
                            $modeltranslationupdate->updated_by = Yii::$app->user->identity->id;
                            $modeltranslationupdate->save();
                        }
                    }
                }

                return $this->redirect(['index']);
            }
        }
        return $this->render('update', ['model' => $model,]);
    }

    /**
     * Deletes an existing ContentSlider model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id) {
        ContentSliderTranslation::deleteAll(['slider_translation_parent_id' => $id]);
        $this->findModel($id)->delete();
        return $this->redirect(['index']);
    }

    /**
     * Finds the ContentSlider model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return ContentSlider the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id) {
        if (($model = ContentSlider::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
    }

    public function actionAddtranslation($id) {
        $modeltranslation = new ContentSliderTranslation();
        $modeltranslation->slider_translation_parent_id = $id;
        $modeltranslation->slider_translation_main = 0;
        $modeltranslation->created_at = date("Y-m-d H:i:s");
        $modeltranslation->created_by = Yii::$app->user->identity->id;
        $modeltranslation->updated_at = date("Y-m-d H:i:s");
        $modeltranslation->updated_by = Yii::$app->user->identity->id;
        $modeltranslation->save();
        return $this->redirect(['update', 'id' => $id]);
    }

    public function actionDeletetranslation($id) {
        if (($model = ContentSliderTranslation::findOne($id)) !== null) {
            $model->delete();
        }
    }

    public function actionGetsubcategory($parent_code = '') {
        $output = '';
        $arr = ArrayHelper::map(
                        (new \yii\db\Query())->select(['code', 'descr'])
                                ->from('ref')
                                ->where(['=', 'cat', 'SLIDERTRANSITION'])
                                ->andwhere(['=', 'param1', $parent_code])
                                ->orderBy(['descr' => SORT_ASC])
                                ->all(), 'code', 'descr');
        if (!empty($arr)) {
            foreach ($arr as $code => $label) {
                $output .= '<option value="' . $code . '">' . $label . '</option>';
            }
        }
        return $output;
    }

}
