<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\helpers\ArrayHelper;

/* @var $this yii\web\View */
/* @var $searchModel backend\modules\contentSlider\models\ContentSliderSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = Yii::t('app', 'Slider');
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="wrapper wrapper-content">
    <p>
        <?= Html::a(Yii::t('app', 'Create Slider'), ['create'], ['class' => 'btn btn-primary']) ?>
    </p>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>
    <div class="ibox animated fadeInRight">
        <div class="mail-box b-r-md">
            <?=
            GridView::widget([
                'dataProvider' => $dataProvider,
                'filterModel' => $searchModel,
                'tableOptions' => ['class' => 'table',],
                'summary' => '',
                'columns' => [
                    ['class' => 'yii\grid\SerialColumn'],
                    [
                        'attribute' => 'slider_image_my',
                        'value' => function ($model) {
                            if(!empty($model->slider_image_my))
                                return '<img width="150px" src="'.Yii::getAlias('@web') .'/'.$model->slider_image_my. '"/>';
                            else
                                return '<img width="150px" src="'.Yii::getAlias('@web') .'/images/noimage.jpg" />';
                        },
                        'format' => 'raw',
                    ],
					[
                        'attribute' => 'slider_title_my',
                        'value' => function ($model) {
                            return $model->slider_title_my;
                        }
                    ],
                    [
                        'attribute' => 'slider_category',
                        'headerOptions' => ['style' => 'width:10%'],
                        'filter' => ArrayHelper::map(
                                (new \yii\db\Query())->select(['code', 'descr'])
                                        ->from('ref')
                                        ->where(['=', 'cat', 'SLIDERCATEGORY'])
                                        ->orderBy(['sort' => SORT_ASC])
                                        ->all(), 'code', 'descr'),
                        'value' => function ($model) {
                            $ref = (new \yii\db\Query())->select(['descr'])
                                    ->from('ref')
                                    ->where(['=', 'cat', 'SLIDERCATEGORY'])
                                    ->andwhere(['=', 'code', $model->slider_category])
                                    ->one();
                            if (!empty($ref))
                                return $ref['descr'];
                        }
                    ],
					[
                        'attribute' => 'slider_status',
                        'headerOptions' => ['style' => 'width:10%'],
                        'filter' => ArrayHelper::map(
                                (new \yii\db\Query())->select(['code', 'descr'])
                                        ->from('ref')
                                        ->where(['=', 'cat', 'SLIDERSTATUS'])
                                        ->orderBy(['sort' => SORT_ASC])
                                        ->all(), 'code', 'descr'),
                        'value' => function ($model) {
                            $ref = (new \yii\db\Query())->select(['descr'])
                                    ->from('ref')
                                    ->where(['=', 'cat', 'SLIDERSTATUS'])
                                    ->andwhere(['=', 'code', $model->slider_status])
                                    ->one();
                            if (!empty($ref))
                                return $ref['descr'];
                        }
                    ],
                    [
                        'class' => 'yii\grid\ActionColumn',
                        'header' => 'Action',
                        'template' => '{update} {delete}',
                        'headerOptions' => ['style' => 'text-align:center;width:10%'],
                        'contentOptions' => ['style' => 'text-align:center;'],
                    ],
                ],
            ]);
            ?>
        </div>
    </div>
</div>
