<?php

use mihaildev\ckeditor\CKEditor;
use mihaildev\elfinder\ElFinder;
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use kartik\file\FileInput;

/* @var $this yii\web\View */
/* @var $model backend\modules\contentSlider\models\ContentSlider */
/* @var $form yii\widgets\ActiveForm */
$this->registerCssFile('@web/plugins/summernote/summernote.min.css');
$this->registerJsFile('@web/plugins/summernote/summernote.min.js', ['depends' => [\yii\web\JqueryAsset::className()]]);

$this->registerJs(
        <<<JS
    $('.summernote').summernote({height: 300});
    $('#w0').on('keyup keypress', function(e) {
        var keyCode = e.keyCode || e.which;
        if (keyCode === 13) { 
          e.preventDefault();
          return false;
        }
      });
JS
);
?>
<?php $form = ActiveForm::begin(); ?>
<div class="wrapper wrapper-content animated fadeInRight" style="padding: 20px 10px 20px;">
    <div class="ibox float-e-margins">
        <div class="ibox-content">
            <div class="row">
                <div class="col-sm-4">
                    <?=
                    $form->field($model, 'slider_category')->dropdownList(
                            ArrayHelper::map(
                                    (new \yii\db\Query())->select(['code', 'descr'])
                                            ->from('ref')
                                            ->where(['=', 'cat', 'SLIDERCATEGORY'])
                                            ->orderBy(['sort' => SORT_ASC])
                                            ->all(), 'code', 'descr'), [
                        'maxlength' => true,])
                    ?>
                </div>
                <div class="col-sm-4">
                    <?=
                    $form->field($model, 'slider_transition')->dropdownList(
                            ArrayHelper::map(
                                    (new \yii\db\Query())->select(['code', 'descr'])
                                            ->from('ref')
                                            ->where(['=', 'cat', 'SLIDERTRANSITION'])
                                            ->orderBy(['sort' => SORT_ASC])
                                            ->all(), 'code', 'descr'), [
                        'maxlength' => true])
                    ?>
                </div>
                <div class="col-sm-4"><?= $form->field($model, 'slider_sorting')->textInput() ?></div>
            </div>
            <div class="row">
				<div class="col-sm-8"><?= $form->field($model, 'slider_url')->textInput(['maxlength' => true]) ?></div>
                <div class="col-sm-4">
                    <?=
                    $form->field($model, 'slider_status')->dropdownList(
                            ArrayHelper::map(
                                    (new \yii\db\Query())->select(['code', 'descr'])
                                            ->from('ref')
                                            ->where(['=', 'cat', 'SLIDERSTATUS'])
                                            ->orderBy(['sort' => SORT_ASC])
                                            ->all(), 'code', 'descr'), [
                        'maxlength' => true,])
                    ?>
                </div>
            </div>
        </div>
    </div>

    <div class="ibox float-e-margins">
        <div class="ibox-content">
            <div class="row">
                <div class="col-sm-12"><?= $form->field($model, 'slider_title_my')->textInput() ?></div>

                <div class="col-sm-6">
                    <?= $form->field($model, 'slider_content_my')->textarea(['class' => 'summernote']) ?>
                </div>
                <div class="col-sm-6">
                    <?php
                    $img_url = Yii::getAlias('@web') . '/images/noimage.jpg';
                    if (!empty($model->slider_image_my)) {
                        echo $form->field($model, 'slider_image_my')->widget(FileInput::classname(), [
                            'options' => ['accept' => 'image/*'],
                            'pluginOptions' => [
                                'showUpload' => false,
                                'initialPreview' => [
                                    '<img style="width:100%" src="' . Yii::getAlias('@web') . '/' . $model->slider_image_my . '"/>',
                                ],
                            ]
                        ]);
                    } else {
                        echo $form->field($model, 'slider_image_my')->widget(FileInput::classname(), [
                            'options' => ['accept' => 'image/*'],
                        ]);
                    }
                    ?>
                </div>
            </div>
            
        </div> 
    </div>

    <div class="ibox float-e-margins">
        <div class="ibox-content">
            <div class="row">
                <div class="col-sm-12"><?= $form->field($model, 'slider_title_en')->textInput() ?></div>

                <div class="col-sm-6">
                    <?= $form->field($model, 'slider_content_en')->textarea(['class' => 'summernote']) ?>
                </div>
                <div class="col-sm-6">
                    <?php
                    $img_url = Yii::getAlias('@web') . '/images/noimage.jpg';
                    if (!empty($model->slider_image_en)) {
                        echo $form->field($model, 'slider_image_en')->widget(FileInput::classname(), [
                            'options' => ['accept' => 'image/*'],
                            'pluginOptions' => [
                                'showUpload' => false,
                                'initialPreview' => [
                                    '<img style="width:100%" src="' . Yii::getAlias('@web') . '/' . $model->slider_image_en . '"/>',
                                ],
                            ]
                        ]);
                    } else {
                        echo $form->field($model, 'slider_image_en')->widget(FileInput::classname(), [
                            'options' => ['accept' => 'image/*'],
                        ]);
                    }
                    ?>
                </div>
            </div>
            
        </div> 
    </div>

    <div class="ibox float-e-margins">
        <div class="ibox-content">
            <div class="row">
                <div class="col-sm-12"><?= $form->field($model, 'slider_title_zh')->textInput() ?></div>

                <div class="col-sm-6">
                    <?= $form->field($model, 'slider_content_zh')->textarea(['class' => 'summernote']) ?>
                </div>
                <div class="col-sm-6">
                    <?php
                    $img_url = Yii::getAlias('@web') . '/images/noimage.jpg';
                    if (!empty($model->slider_image_zh)) {
                        echo $form->field($model, 'slider_image_zh')->widget(FileInput::classname(), [
                            'options' => ['accept' => 'image/*'],
                            'pluginOptions' => [
                                'showUpload' => false,
                                'initialPreview' => [
                                    '<img style="width:100%" src="' . Yii::getAlias('@web') . '/' . $model->slider_image_zh . '"/>',
                                ],
                            ]
                        ]);
                    } else {
                        echo $form->field($model, 'slider_image_zh')->widget(FileInput::classname(), [
                            'options' => ['accept' => 'image/*'],
                        ]);
                    }
                    ?>
                </div>
            </div>
            
        </div> 
    </div>
    
    <div class="form-group">
        <?= Html::submitButton($model->isNewRecord ? 'Create' : 'Update', ['class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary']) ?>
    </div>
</div>
<?php ActiveForm::end(); ?>
