<?php

namespace backend\modules\contentSlider\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\modules\contentSlider\models\ContentSlider;

/**
 * ContentSliderSearch represents the model behind the search form of `backend\modules\contentSlider\models\ContentSlider`.
 */
class ContentSliderSearch extends ContentSlider {

    public $slider_title;

    /**
     * {@inheritdoc}
     */
    public function rules() {
        return [
            [['slider_id','slider_sorting',  'created_by', 'updated_by'], 'integer'],
            [['slider_category', 'slider_status','slider_transition', 'slider_url', 'created_at', 'updated_at', 'slider_title_my','slider_image_my','slider_content_my','slider_title_en','slider_image_en','slider_content_en'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios() {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params) {
        $query = ContentSlider::find();

        // add conditions that should always apply here
        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere(['=', 'slider_category', $this->slider_category]);
        $query->andFilterWhere(['=', 'slider_status', $this->slider_status]);
        $query->andFilterWhere(['LIKE', 'slider_title_my', $this->slider_title_my]);
        $query->andFilterWhere(['LIKE', 'slider_title_en', $this->slider_title_en]);
        $query->andFilterWhere(['LIKE', 'slider_title_zh', $this->slider_title_zh]);


        return $dataProvider;
    }

}
