<?php

namespace backend\modules\contentSlider\models;

use Yii;

/**
 * This is the model class for table "content_slider".
 *
 * @property int $slider_id
 * @property string|null $slider_transition
 * @property string|null $slider_category
 * @property string|null $slider_status
 * @property string|null $slider_url
 * @property int|null $slider_sorting
 * @property string|null $created_at
 * @property int|null $created_by
 * @property string|null $updated_at
 * @property int|null $updated_by
 */
class ContentSlider extends \yii\db\ActiveRecord {

    /**
     * {@inheritdoc}
     */
    public static function tableName() {
        return 'content_slider';
    }

    /**
     * {@inheritdoc}
     */
    public function rules() {
        return [
            [['slider_title_my','slider_transition', 'slider_category'], 'required'],
            [['created_at', 'updated_at'], 'safe'],
            [['slider_sorting','created_by', 'updated_by'], 'integer'],
            [['slider_title_my','slider_title_en', 'slider_title_zh','slider_content_my','slider_content_en','slider_content_zh'], 'string'],
            [['slider_category','slider_transition', 'slider_status', 'slider_url', 'slider_image_my','slider_image_en','slider_image_zh'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels() {
        return [
            'slider_id' => Yii::t('app', 'Slider ID'),
            'slider_title_my' => Yii::t('app', 'Title [MY]'),
            'slider_content_my' => Yii::t('app', 'Content [MY]'),
            'slider_image_my' => Yii::t('app', 'Image Slider [MY]'),
            'slider_title_en' => Yii::t('app', 'Title [EN]'),
            'slider_content_en' => Yii::t('app', 'Content [EN]'),
            'slider_image_en' => Yii::t('app', 'Image Slider [EN]'),
            'slider_title_zh' => Yii::t('app', 'Title [CH]'),
            'slider_content_zh' => Yii::t('app', 'Content [CH]'),
            'slider_image_zh' => Yii::t('app', 'Image Slider [EN]'),
            'slider_category' => Yii::t('app', 'Portal Category'),
            'slider_transition' => Yii::t('app', 'Transition'),			
            'slider_url' => Yii::t('app', 'URL Related'),
            'slider_sorting' => Yii::t('app', 'Sorting'),
            'slider_status' => Yii::t('app', 'Status'),
            'created_at' => Yii::t('app', 'Created At'),
            'created_by' => Yii::t('app', 'Created By'),
            'updated_at' => Yii::t('app', 'Updated At'),
            'updated_by' => Yii::t('app', 'Updated By'),
        ];
    }

}
