<?php

namespace backend\modules\contentSlider\controllers;

use Yii;
use backend\modules\contentSlider\models\ContentSlider;
use backend\modules\contentSlider\models\ContentSliderSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\web\UploadedFile;
use yii\helpers\ArrayHelper;
use yii\helpers\Html;

/**
 * ContentSliderController implements the CRUD actions for ContentSlider model.
 */
class ContentSliderController extends Controller {

    /**
     * {@inheritdoc}
     */
    public function behaviors() {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all ContentSlider models.
     * @return mixed
     */
    public function actionIndex() {
        $searchModel = new ContentSliderSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
                    'searchModel' => $searchModel,
                    'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single ContentSlider model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id) {
        return $this->render('view', [
                    'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new ContentSlider model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate() {
        $model = new ContentSlider();
        $model->created_at = date("Y-m-d H:i:s");
        $model->created_by = Yii::$app->user->identity->id;
        $model->updated_at = date("Y-m-d H:i:s");
        $model->updated_by = Yii::$app->user->identity->id;

        if ($model->load(Yii::$app->request->post())) {

            //upload file image 
            $model->slider_image_my = UploadedFile::getInstance($model, 'slider_image_my');
            $model->slider_image_en = UploadedFile::getInstance($model, 'slider_image_en');
            $model->slider_image_zh = UploadedFile::getInstance($model, 'slider_image_zh');

            if (!empty($model->slider_image_my)) {
                $slider_image_my = 'images/modules/contentSliderMy_'. date("YmdHis") . '.' . $model->slider_image_my->extension;
                if ($model->slider_image_my->saveAs($slider_image_my))
                    $model->slider_image_my = $slider_image_my;
            }

            if (!empty($model->slider_image_en)) {
                $slider_image_en = 'images/modules/contentSliderEn_'. date("YmdHis") . '.' . $model->slider_image_en->extension;
                if ($model->slider_image_en->saveAs($slider_image_en))
                    $model->slider_image_en = $slider_image_en;
            }

            if (!empty($model->slider_image_zh)) {
                $slider_image_zh = 'images/modules/contentSliderZh_'. date("YmdHis") . '.' . $model->slider_image_zh->extension;
                if ($model->slider_image_zh->saveAs($slider_image_zh))
                    $model->slider_image_zh = $slider_image_zh;
            }
            // file is uploaded successfully
             if ($model->save(false)) {
                 return $this->redirect(['index']);
            }
        }
        return $this->render('create', [
                    'model' => $model,
        ]);
    }

    /**
     * Updates an existing ContentSlider model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id) {
        $model = $this->findModel($id);
        $model->updated_at = date("Y-m-d H:i:s");
        $model->updated_by = Yii::$app->user->identity->id;

        $image_my = $model->slider_image_my;
        $image_en = $model->slider_image_en;
        $image_zh = $model->slider_image_zh;

        if ($model->load(Yii::$app->request->post())) {

            $model->slider_image_my = UploadedFile::getInstance($model, 'slider_image_my');
            $model->slider_image_en = UploadedFile::getInstance($model, 'slider_image_en');
            $model->slider_image_zh = UploadedFile::getInstance($model, 'slider_image_zh');

            if (!empty($model->slider_image_my)) {
                $slider_image_my = 'images/modules/contentSliderMy_' . date("YmdHis") . '.' . $model->slider_image_my->extension;
                if ($model->slider_image_my->saveAs($slider_image_my))
                    $model->slider_image_my = $slider_image_my;
            } else
                $model->slider_image_my = $image_my;

            if (!empty($model->slider_image_en)) {
                $slider_image_en = 'images/modules/contentSliderEn_'. date("YmdHis") . '.' . $model->slider_image_en->extension;
                if ($model->slider_image_en->saveAs($slider_image_en))
                    $model->slider_image_en = $slider_image_en;
            } else
                $model->slider_image_en = $image_en;

            if (!empty($model->slider_image_zh)) {
                $slider_image_zh = 'images/modules/contentSliderZh_'. date("YmdHis") . '.' . $model->slider_image_zh->extension;
                if ($model->slider_image_zh->saveAs($slider_image_zh))
                    $model->slider_image_zh = $slider_image_zh;
            } else
                $model->slider_image_zh = $image_zh;

            // file is uploaded successfully
             if ($model->save(false)) {
                 return $this->redirect(['index']);
            }
        }
        return $this->render('update', ['model' => $model,]);
    }

    /**
     * Deletes an existing ContentSlider model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id) {
        $model = $this->findModel($id);
        $model->delete();
        return $this->redirect(['index']);
    }

    /**
     * Finds the ContentSlider model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return ContentSlider the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id) {
        if (($model = ContentSlider::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
    }
}
