<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model backend\modules\contentAnnouncement\models\ContentAnnouncement */

$this->title = Yii::t('app', 'View Details Photo');
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Photo'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
$this->registerCss('.detail-view th{width:20%;text-align:right;white-space: nowrap;}');
\yii\web\YiiAsset::register($this);
?>
<div class="wrapper wrapper-content animated fadeInRight">
    <?= Html::a(Yii::t('app', 'Back to list'), ['index', 'gallery_id' => $model->photo_gallery_id], ['class' => 'btn btn-primary']) ?><br><br>
    <div class="ibox float-e-margins">
        <div class="ibox-content">
            <?php
            echo DetailView::widget([
                'model' => $model,
                'attributes' => [
                    'photo_sort',
                    [
                        'attribute' => 'photo_url',
                        'format' => 'raw',
                        'value' => function ($model) {
                            $output = '';
                            if (!empty($model->photo_url))
                                $output = '<img src="' . Yii::getAlias('@web') . '/' . $model->photo_url . '" height="100">';
                            return $output;
                        }
                    ],
                    [
                        'attribute' => 'photo_language',
                        'value' => \backend\modules\refdynawebv2\models\Ref::getDesc('CONTENT_LANGUAGE', $model->photo_language),
                    ],
                    [
                        'attribute' => 'photo_descr',
                        'format' => 'raw',
                    ],
                    'created_at',
                    [
                        'attribute' => 'created_by',
                        'value' => \backend\modules\mimin\models\User::getname($model->created_by),
                    ],
                    'updated_at',
                    [
                        'attribute' => 'updated_by',
                        'value' => \backend\modules\mimin\models\User::getname($model->updated_by),
                    ],
                ],
            ]);

            $modelTranslation = \backend\modules\contentPhoto\models\ContentPhotoList::find()
                    ->where(['=', 'photo_parent_id', $model->photo_id])
                    ->orderBy(['photo_id' => SORT_ASC])
                    ->all();
            if (!empty($modelTranslation)) {
                foreach ($modelTranslation as $rowTranslation) {
                    echo '<table class="table table-striped table-bordered detail-view">
                        <tbody>
                            <tr>
                                <th>Language</th>
                                <td>' . \backend\modules\refdynawebv2\models\Ref::getDesc('CONTENT_LANGUAGE', $rowTranslation->photo_language) . '</td>
                            </tr>
                            <tr>
                                <th>Description</th>
                                <td>' . $rowTranslation->photo_descr . '</td>
                            </tr>
                        </tbody>
                    </table>';
                }
            }
            ?>
        </div>
    </div>
</div>