<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\helpers\ArrayHelper;
use backend\modules\contentPhoto\models\ContentPhotoList;

$this->title = Yii::t('app', 'Photo List');
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="wrapper wrapper-content">
    <p>
        <?= Html::a(Yii::t('app', 'Back to list'), ['content-photo-gallery/index'], ['class' => 'btn btn-primary']) ?>
        <?= Html::a(Yii::t('app', 'Create Photo'), ['create', 'gallery_id' => Yii::$app->getRequest()->getQueryParam('gallery_id')], ['class' => 'btn btn-primary']) ?>
    </p>
    <div class="ibox animated fadeInRight">
        <div class="mail-box b-r-md">
            <?=
            GridView::widget([
                'dataProvider' => $dataProvider,
                'filterModel' => $searchModel,
                'tableOptions' => ['class' => 'table',],
                'summary' => '',
                'columns' => [
                    ['class' => 'yii\grid\SerialColumn'],
                    [
                        'attribute' => 'photo_url',
                        'filter' => false,
                        'format'=>'raw',
                        'value' => function ($model) {
                            return '<img style="height:80px;" src="' . Yii::getAlias('@web') . '/' . $model->photo_url . '"/>';
                        }
                    ],
                    'photo_descr',
                    'photo_sort',
                    [
                        'header' => 'Language',
                        'format' => 'raw',
                        'value' => function ($model) {
                            $output = '';
                            $arr = ArrayHelper::map(
                                            (new \yii\db\Query())->select(['*'])
                                                    ->from('content_photo_list')
                                                    ->orderBy(['photo_language' => SORT_ASC])
                                                    ->groupby(['photo_language'])
                                                    ->all(), 'photo_language', 'photo_language');
                            if (!empty($arr)) {
                                foreach ($arr as $code) {
                                    $ref = (new \yii\db\Query())->select(['descr'])
                                            ->from('ref')
                                            ->where(['=', 'cat', 'CONTENT_LANGUAGE'])
                                            ->andwhere(['=', 'code', $code])
                                            ->one();
                                    if (!empty($ref)) {
                                        $label_class = 'label-dark';
                                        if (($modeltranslation = ContentPhotoList::findOne(['photo_id' => $model->photo_id, 'photo_language' => $code])) !== null) {
                                            $label_class = 'label-primary';
                                        }
                                        if (($modeltranslation = ContentPhotoList::findOne(['photo_parent_id' => $model->photo_id, 'photo_language' => $code])) !== null) {
                                            $label_class = 'label-primary';
                                        }
                                        $output .= '<span class="label ' . $label_class . '">' . $ref['descr'] . '</span>&nbsp;&nbsp;';
                                    }
                                }
                            }
                            return $output . Html::a('<i class="fa fa-plus" aria-hidden="true"></i>', ['addtranslation', 'id' => $model->photo_id], ['class' => 'label label-danger']);
                        }
                    ],
                    [
                        'class' => 'yii\grid\ActionColumn',
                        'header' => 'Action',
                        'template' => '{view}&nbsp;{update}&nbsp;{delete}',
                        'headerOptions' => ['style' => 'text-align:center;width:10%'],
                        'contentOptions' => ['style' => 'text-align:center;'],
                    ],
                ],
            ]);
            ?>
        </div>
    </div>
</div>
