<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\file\FileInput;
use yii\helpers\ArrayHelper;
use backend\modules\contentPhoto\models\ContentPhotoList;

/* @var $this yii\web\View */
/* @var $model backend\modules\contentPhoto\models\ContentPhotoList */
/* @var $form yii\widgets\ActiveForm */
?>
<?php $form = ActiveForm::begin(); ?>
<div class="wrapper wrapper-content animated fadeInRight" style="padding: 20px 10px 20px;">
    <div class="ibox float-e-margins">
        <div class="ibox-content">
            <?= $form->field($model, 'photo_sort')->textInput() ?>
            <?php
            if (!empty($model->photo_url)) {
                echo $form->field($model, 'photo_url')->widget(FileInput::classname(), [
                    'options' => ['accept' => 'image/*'],
                    'pluginOptions' => [
                        'showUpload' => false,
                        'showCaption' => false,
                        'showRemove' => false,
                        'showUpload' => false,
                        'browseClass' => 'btn btn-warning btn-block',
                        'browseIcon' => '<i class="glyphicon glyphicon-camera"></i>&nbsp;&nbsp;',
                        'browseLabel' => 'Select Photo',
                        'initialPreview' => ['<img style="max-width:100%" src="' . Yii::getAlias('@web') . '/' . $model->photo_url . '"/>'],
                    ]
                ]);
            } else {
                echo $form->field($model, 'photo_url')->widget(FileInput::classname(), [
                    'options' => ['accept' => 'image/*'],
                    'pluginOptions' => [
                        'showUpload' => false,
                        'showCaption' => false,
                        'showRemove' => false,
                        'showUpload' => false,
                        'browseClass' => 'btn btn-warning btn-block',
                        'browseIcon' => '<i class="glyphicon glyphicon-camera"></i>&nbsp;&nbsp;',
                        'browseLabel' => 'Select Photo'
                    ],
                ]);
            }
            ?>

            <?=
            $form->field($model, 'photo_language')->dropdownList(
                    ArrayHelper::map(
                            (new \yii\db\Query())->select(['code', 'descr'])
                                    ->from('ref')
                                    ->where(['=', 'cat', 'CONTENT_LANGUAGE'])
                                    ->orderBy(['sort' => SORT_ASC])
                                    ->all(), 'code', 'descr'), [
                'maxlength' => true, 'prompt' => '-- Please choose --'])
            ?>
            <?= $form->field($model, 'photo_descr')->textarea(['rows' => 6]) ?>
        </div>
    </div>

    <?php
    $modeltranslation = ContentPhotoList::find()
                    ->where(['=', 'photo_parent_id', $model->photo_id])
                    ->andwhere(['=', 'photo_main', '0'])
                    ->orderBy(['photo_id' => SORT_ASC])->all();
    if (!empty($modeltranslation)) {
        foreach ($modeltranslation as $rowtranslation) {
            echo '<div class="ibox float-e-margins" id="old-translation-' . $rowtranslation->photo_id . '">
            <input type="hidden" name="oldtranslation[]" value="' . $rowtranslation->photo_id . '">
            <div class="ibox-title">
                <button type="button" class="btn btn-primary btn-sm" onclick="deleteoldtranslation(' . $rowtranslation->photo_id . ')">Delete</button>&nbsp;&nbsp;&nbsp;
                Photo Translation
            </div>
            <div class="ibox-content">
                <div class="form-group">
                    <label>Language</label>
                    ' . Html::dropDownList('old_language_' . $rowtranslation->photo_id, $rowtranslation->photo_language, ArrayHelper::map(
                            (new \yii\db\Query())->select(['code', 'descr'])
                                    ->from('ref')
                                    ->where(['=', 'cat', 'CONTENT_LANGUAGE'])
                                    ->orderBy(['sort' => SORT_ASC])
                                    ->all(), 'code', 'descr'), [
                'class' => 'form-control', 'prompt' => '-- Please choose --',]) . '
                </div>
                <div class="form-group">
                    <label>Description</label>
                    <textarea rows="6" class="form-control" name="old_descr_' . $rowtranslation->photo_id . '">' . $rowtranslation->photo_descr . '</textarea>
                </div>
            </div>
        </div>';
        }
    }
    ?>

    <div class="form-group">
        <?= Html::a(Yii::t('app', 'Back'), ['index', 'gallery_id' => $model->photo_gallery_id], ['class' => 'btn btn-primary']) ?>
        <?= Html::submitButton(Yii::t('app', 'Save'), ['class' => 'btn btn-success']) ?>
    </div>
</div>
<?php ActiveForm::end(); ?>
<script>
    function deleteoldtranslation(id) {
        var r = confirm("Are you sure to delete this data?");
        if (r == true) {
            $.ajax({
                url: "deletetranslation?id=" + id,
                method: "GET",
                success: function (response) {
                    $('#old-translation-' + id).remove();
                },
            });
        }
    }
</script>