<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model backend\modules\contentAnnouncement\models\ContentAnnouncement */

$this->title = Yii::t('app', 'View Details Photo Gallery');
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Photo Gallery'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
$this->registerCss('.detail-view th{width:20%;text-align:right;white-space: nowrap;}');
\yii\web\YiiAsset::register($this);
?>
<div class="wrapper wrapper-content animated fadeInRight">
    <?= Html::a(Yii::t('app', 'Back to list'), ['index'], ['class' => 'btn btn-primary']) ?><br><br>
    <div class="ibox float-e-margins">
        <div class="ibox-content">
            <?php
            echo DetailView::widget([
                'model' => $model,
                'attributes' => [
                    [
                        'attribute' => 'gallery_portal',
                        'value' => \backend\modules\refdynawebv2\models\Ref::getDesc('GALLERYPORTAL', $model->gallery_portal),
                    ],
                    [
                        'attribute' => 'gallery_status',
                        'value' => \backend\modules\refdynawebv2\models\Ref::getDesc('CONTENT_STATUS', $model->gallery_status),
                    ],
                    [
                        'attribute' => 'gallery_cat',
                        'value' => \backend\modules\refdynawebv2\models\Ref::getDesc('GALLERYCAT', $model->gallery_cat, 'descr'),
                    ],
                    'gallery_code',
                    'gallery_date',
                    'gallery_location',
                    [
                        'attribute' => 'gallery_thumbnail',
                        'format' => 'raw',
                        'value' => function ($model) {
                            $output = '';
                            if (!empty($model->gallery_thumbnail))
                                $output = '<img src="' . Yii::getAlias('@web') . '/' . $model->gallery_thumbnail . '" height="100">';
                            return $output;
                        }
                    ],
                    [
                        'attribute' => 'gallery_language',
                        'value' => \backend\modules\refdynawebv2\models\Ref::getDesc('CONTENT_LANGUAGE', $model->gallery_language),
                    ],
                    'gallery_title',
                    [
                        'attribute' => 'gallery_descr',
                        'format' => 'raw',
                    ],
                    
                ],
            ]);

            $modelTranslation = \backend\modules\contentPhoto\models\ContentPhotoGallery::find()
                    ->where(['=', 'gallery_parent_id', $model->gallery_id])
                    ->orderBy(['gallery_id' => SORT_ASC])
                    ->all();
            if (!empty($modelTranslation)) {
                foreach ($modelTranslation as $rowTranslation) {
                    echo '<table class="table table-striped table-bordered detail-view">
                        <tbody>
                            <tr>
                                <th>Language</th>
                                <td>' . \backend\modules\refdynawebv2\models\Ref::getDesc('CONTENT_LANGUAGE', $rowTranslation->gallery_language) . '</td>
                            </tr>
                            <tr>
                                <th>Title</th>
                                <td>' . $rowTranslation->gallery_title . '</td>
                            </tr>
                            <tr>
                                <th>Description</th>
                                <td>' . $rowTranslation->gallery_descr . '</td>
                            </tr>
                        </tbody>
                    </table>';
                }
            }
            ?>
        </div>
    </div>
</div>