<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\helpers\ArrayHelper;
use backend\modules\contentPhoto\models\ContentPhotoGallery;

$this->title = Yii::t('app', 'Photo Gallery');
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="wrapper wrapper-content">
    <p><?= Html::a(Yii::t('app', 'Create Photo Gallery'), ['create'], ['class' => 'btn btn-primary']) ?></p>
    <div class="ibox animated fadeInRight">
        <div class="mail-box b-r-md">
            <?=
            GridView::widget([
                'dataProvider' => $dataProvider,
                'filterModel' => $searchModel,
                'tableOptions' => ['class' => 'table',],
                'summary' => '',
                'columns' => [
                    ['class' => 'yii\grid\SerialColumn'],
                    'gallery_title',
                    'gallery_code',
                    //'gallery_date',
                    //'gallery_location',
                    [
                        'attribute' => 'gallery_portal',
                        'filter' => ArrayHelper::map(
                                (new \yii\db\Query())->select(['code', 'descr'])
                                        ->from('ref')
                                        ->where(['=', 'cat', 'GALLERYPORTAL'])
                                        ->orderBy(['sort' => SORT_ASC])
                                        ->all(), 'code', 'descr'),
                        'value' => function ($model) {
                            $ref = (new \yii\db\Query())->select(['descr'])
                                    ->from('ref')
                                    ->where(['=', 'cat', 'GALLERYPORTAL'])
                                    ->andwhere(['=', 'code', $model->gallery_portal])
                                    ->one();
                            if (!empty($ref))
                                return $ref['descr'];
                        }
                    ],
                    [
                        'attribute' => 'gallery_status',
                        'filter' => ArrayHelper::map(
                                (new \yii\db\Query())->select(['code', 'descr'])
                                        ->from('ref')
                                        ->where(['=', 'cat', 'CONTENT_STATUS'])
                                        ->orderBy(['sort' => SORT_ASC])
                                        ->all(), 'code', 'descr'),
                        'value' => function ($model) {
                            $ref = (new \yii\db\Query())->select(['descr'])
                                    ->from('ref')
                                    ->where(['=', 'cat', 'CONTENT_STATUS'])
                                    ->andwhere(['=', 'code', $model->gallery_status])
                                    ->one();
                            if (!empty($ref))
                                return $ref['descr'];
                        }
                    ],
                    [
                        'attribute' => 'gallery_cat',
                        'filter' => ArrayHelper::map(
                                (new \yii\db\Query())->select(['code', 'descr'])
                                        ->from('ref')
                                        ->where(['=', 'cat', 'GALLERYCAT'])
                                        ->orderBy(['descr' => SORT_ASC])
                                        ->all(), 'code', 'descr'),
                        'value' => function ($model) {
                            $ref = (new \yii\db\Query())->select(['descr'])
                                    ->from('ref')
                                    ->where(['=', 'cat', 'GALLERYCAT'])
                                    ->andwhere(['=', 'code', $model->gallery_cat])
                                    ->one();
                            if (!empty($ref))
                                return $ref['descr'];
                        }
                    ],
                    [
                        'header' => 'Language',
                        'format' => 'raw',
                        'value' => function ($model) {
                            $output = '';
                            $arr = ArrayHelper::map(
                                            (new \yii\db\Query())->select(['*'])
                                                    ->from('content_photo_gallery')
                                                    ->orderBy(['gallery_language' => SORT_ASC])
                                                    ->groupby(['gallery_language'])
                                                    ->all(), 'gallery_language', 'gallery_language');
                            if (!empty($arr)) {
                                foreach ($arr as $code) {
                                    $ref = (new \yii\db\Query())->select(['descr'])
                                            ->from('ref')
                                            ->where(['=', 'cat', 'CONTENT_LANGUAGE'])
                                            ->andwhere(['=', 'code', $code])
                                            ->one();
                                    if (!empty($ref)) {
                                        $label_class = 'label-dark';
                                        if (($modeltranslation = ContentPhotoGallery::findOne(['gallery_id' => $model->gallery_id, 'gallery_language' => $code])) !== null) {
                                            $label_class = 'label-primary';
                                        }
                                        if (($modeltranslation = ContentPhotoGallery::findOne(['gallery_parent_id' => $model->gallery_id, 'gallery_language' => $code])) !== null) {
                                            $label_class = 'label-primary';
                                        }
                                        $output .= '<span class="label ' . $label_class . '">' . $ref['descr'] . '</span>&nbsp;&nbsp;';
                                    }
                                }
                            }
                            return $output . Html::a('<i class="fa fa-plus" aria-hidden="true"></i>', ['addtranslation', 'id' => $model->gallery_id], ['class' => 'label label-danger']);
                        }
                    ],
                    [
                        'class' => 'yii\grid\ActionColumn',
                        'header' => 'Action',
                        'template' => '{photo}&nbsp;&nbsp;{view}&nbsp;{update}&nbsp;{delete}',
                        'headerOptions' => ['style' => 'text-align:center;width:10%'],
                        'contentOptions' => ['style' => 'text-align:center;'],
                        'buttons' => [
                            'photo' => function ($url, $model) {
                                return Html::a('<span class="fa fa-picture-o">',
                                                ['content-photo-list/index', 'gallery_id' => $model->gallery_id],
                                                ['title' => 'Add Photo', 'data-pjax' => '0']);
                            },
                        ],
                    ],
                ],
            ]);
            ?>
        </div>
    </div>
</div>
