<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\file\FileInput;
use yii\helpers\ArrayHelper;
use backend\modules\contentPhoto\models\ContentPhotoGallery;

$this->registerCssFile('@web/plugins/summernote/summernote.min.css');
$this->registerJsFile('@web/plugins/summernote/summernote.min.js', ['depends' => [\yii\web\JqueryAsset::className()]]);

$this->registerJs(
        <<<JS
    $('#contentphotogallery-gallery_date').datepicker({'format':'yyyy-mm-dd'});
    $('.summernote').summernote({height: 300});
JS
);
$this->registerCss(".note-editor{border:1px solid #e5e6e7 !important}");
?>
<?php $form = ActiveForm::begin(); ?>
<div class="wrapper wrapper-content animated fadeInRight" style="padding: 20px 10px 20px;">
    <div class="ibox float-e-margins">
        <div class="ibox-content">
            <div class="row">
                <div class="col-sm-3">
                    <?=
                    $form->field($model, 'gallery_portal')->dropdownList(
                            ArrayHelper::map(
                                    (new \yii\db\Query())->select(['code', 'descr'])
                                            ->from('ref')
                                            ->where(['=', 'cat', 'GALLERYPORTAL'])
                                            ->orderBy(['sort' => SORT_ASC])
                                            ->all(), 'code', 'descr'), [
                        'maxlength' => true, 'prompt' => '-- Please choose --'])
                    ?>
                </div>
                <div class="col-sm-3">
                    <?=
                    $form->field($model, 'gallery_status')->dropdownList(
                            ArrayHelper::map(
                                    (new \yii\db\Query())->select(['code', 'descr'])
                                            ->from('ref')
                                            ->where(['=', 'cat', 'CONTENT_STATUS'])
                                            ->orderBy(['sort' => SORT_ASC])
                                            ->all(), 'code', 'descr'), [
                        'maxlength' => true, 'prompt' => '-- Please choose --'])
                    ?>
                </div>
                <div class="col-sm-3">
                    <?=
                    $form->field($model, 'gallery_cat')->dropdownList(
                            ArrayHelper::map(
                                    (new \yii\db\Query())->select(['code', 'descr'])
                                            ->from('ref')
                                            ->where(['=', 'cat', 'GALLERYCAT'])
                                            ->orderBy(['descr' => SORT_ASC])
                                            ->all(), 'code', 'descr'), [
                        'maxlength' => true, 'prompt' => '-- Please choose --'])
                    ?>
                </div>
                <div class="col-sm-3"><?= $form->field($model, 'gallery_date')->textInput(['readonly' => true]) ?></div>
            </div>
            <div class="row">
                <div class="col-sm-6"><?= $form->field($model, 'gallery_location')->textInput(['maxlength' => true]) ?></div>
                <div class="col-sm-6"><?= $form->field($model, 'gallery_code')->textInput(['placeholder' => 'pelancaran-jelajah-hiper-19']) ?></div>
            </div>
            <?php
            if (!empty($model->gallery_thumbnail)) {
                echo $form->field($model, 'gallery_thumbnail')->widget(FileInput::classname(), [
                    'options' => ['accept' => 'image/*'],
                    'pluginOptions' => [
                        'showUpload' => false,
                        'showCaption' => false,
                        'showRemove' => false,
                        'showUpload' => false,
                        'browseClass' => 'btn btn-warning btn-block',
                        'browseIcon' => '<i class="glyphicon glyphicon-camera"></i>&nbsp;&nbsp;',
                        'browseLabel' => 'Select Thumbnail',
                        'initialPreview' => ['<img style="max-width:100%" src="' . Yii::getAlias('@web') . '/' . $model->gallery_thumbnail . '"/>'],
                    ]
                ]);
            } else {
                echo $form->field($model, 'gallery_thumbnail')->widget(FileInput::classname(), [
                    'options' => ['accept' => 'image/*'],
                    'pluginOptions' => [
                        'showUpload' => false,
                        'showCaption' => false,
                        'showRemove' => false,
                        'showUpload' => false,
                        'browseClass' => 'btn btn-warning btn-block',
                        'browseIcon' => '<i class="glyphicon glyphicon-camera"></i>&nbsp;&nbsp;',
                        'browseLabel' => 'Select Thumbnail'
                    ],
                ]);
            }
            ?>
            <div class="row">
                <div class="col-sm-3">
                    <?=
                    $form->field($model, 'gallery_language')->dropdownList(
                            ArrayHelper::map(
                                    (new \yii\db\Query())->select(['code', 'descr'])
                                            ->from('ref')
                                            ->where(['=', 'cat', 'CONTENT_LANGUAGE'])
                                            ->orderBy(['sort' => SORT_ASC])
                                            ->all(), 'code', 'descr'), [
                        'maxlength' => true, 'prompt' => '-- Please choose --'])
                    ?>
                </div>
                <div class="col-sm-9"><?= $form->field($model, 'gallery_title')->textInput(['maxlength' => true]) ?></div>
            </div>
            <?= $form->field($model, 'gallery_descr')->textarea(['class' => 'summernote']) ?>
        </div>
    </div>

    <?php
    $modeltranslation = ContentPhotoGallery::find()
                    ->where(['=', 'gallery_parent_id', $model->gallery_id])
                    ->andwhere(['=', 'gallery_main', '0'])
                    ->orderBy(['gallery_id' => SORT_ASC])->all();
    if (!empty($modeltranslation)) {
        foreach ($modeltranslation as $rowtranslation) {
            echo '<div class="ibox float-e-margins" id="old-translation-' . $rowtranslation->gallery_id . '">
            <input type="hidden" name="oldtranslation[]" value="' . $rowtranslation->gallery_id . '">
            <div class="ibox-title">
                <button type="button" class="btn btn-primary btn-sm" onclick="deleteoldtranslation(' . $rowtranslation->gallery_id . ')">Delete</button>&nbsp;&nbsp;&nbsp;
                Photo Gallery Translation
            </div>
            <div class="ibox-content">
                <div class="row">
                    <div class="col-sm-3">
                        <div class="form-group">
                            <label>Language</label>
                            ' . Html::dropDownList('old_language_' . $rowtranslation->gallery_id, $rowtranslation->gallery_language, ArrayHelper::map(
                            (new \yii\db\Query())->select(['code', 'descr'])
                                    ->from('ref')
                                    ->where(['=', 'cat', 'CONTENT_LANGUAGE'])
                                    ->orderBy(['sort' => SORT_ASC])
                                    ->all(), 'code', 'descr'), [
                'class' => 'form-control', 'prompt' => '-- Please choose --',]) . '
                        </div>
                    </div>
                    <div class="col-sm-9">
                        <div class="form-group">
                            <label>Title</label>
                            <input type="text" class="form-control" name="old_title_' . $rowtranslation->gallery_id . '" value="' . $rowtranslation->gallery_title . '">
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <label>Description</label>
                    <textarea class="summernote" name="old_descr_' . $rowtranslation->gallery_id . '">' . $rowtranslation->gallery_descr . '</textarea>
                </div>
            </div>
        </div>';
        }
    }
    ?>

    <div class="form-group">
        <?= Html::a(Yii::t('app', 'Back'), ['index'], ['class' => 'btn btn-primary']) ?>
        <?= Html::submitButton(Yii::t('app', 'Save'), ['class' => 'btn btn-success']) ?>
    </div>
</div>
<?php ActiveForm::end(); ?>    
<script>function deleteoldtranslation(id) {
        var r = confirm("Are you sure to delete this data?");
        if (r == true) {
            $.ajax({
                url: "deletetranslation?id=" + id,
                method: "GET",
                success: function (response) {
                    $('#old-translation-' + id).remove();
                },
            });
        }
    }
</script>