<?php

namespace backend\modules\contentPhoto\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\modules\contentPhoto\models\ContentPhotoList;

/**
 * ContentPhotoListSearch represents the model behind the search form of `backend\modules\contentPhoto\models\ContentPhotoList`.
 */
class ContentPhotoListSearch extends ContentPhotoList {

    /**
     * {@inheritdoc}
     */
    public function rules() {
        return [
            [['photo_id', 'photo_main', 'photo_parent_id', 'photo_sort'], 'integer'],
            [['photo_language', 'photo_url', 'photo_descr', 'created_at', 'created_by', 'updated_at', 'updated_by'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios() {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params) {
        $query = ContentPhotoList::find();

        // add conditions that should always apply here
        $dataProvider = new ActiveDataProvider(['query' => $query, 'pagination' => ['pageSize' => 10,]]);
        $dataProvider->setSort(['defaultOrder' => ['photo_sort' => SORT_ASC]]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        $query->andFilterWhere(['=', 'photo_sort', $this->photo_sort])
                ->andFilterWhere(['like', 'photo_descr', $this->photo_descr]);
        $query->andWhere(['=', 'photo_main', '1']);
        $query->andWhere(['=', 'photo_gallery_id', $this->photo_gallery_id]);

        return $dataProvider;
    }

}
